/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations;

import com.google.common.collect.Iterables;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.Implementations.CSteppingHelper;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.disassembly.CCodeNodeHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.zygraph.helpers.INodeCallback;
import com.google.security.zynamics.zylib.types.common.IterationMode;
import java.util.HashSet;
import java.util.Set;

public final class CStepOverHelper {
    private CStepOverHelper() {
    }

    private static void stepInCodeNode(INaviCodeNode node, UnrelocatedAddress address, Set<BreakpointAddress> instructions) {
        int instructionIndex = CCodeNodeHelpers.getInstruction(node, address.getAddress());
        if (instructionIndex != -1) {
            if (instructionIndex < node.instructionCount() - 1) {
                INaviInstruction instruction = (INaviInstruction)Iterables.get(node.getInstructions(), instructionIndex + 1);
                instructions.add(new BreakpointAddress(instruction.getModule(), new UnrelocatedAddress(instruction.getAddress())));
            } else {
                instructions.addAll(CSteppingHelper.getSuccessors(node));
            }
        }
    }

    private static void stepInFunctionNode(INaviFunctionNode node, UnrelocatedAddress address, Set<BreakpointAddress> instructions) {
        if (address.getAddress().equals(node.getFunction().getAddress())) {
            instructions.addAll(CSteppingHelper.getSuccessors(node));
        }
    }

    public static Set<BreakpointAddress> getNextInstructions(ZyGraph graph, final UnrelocatedAddress address) {
        final HashSet<BreakpointAddress> instructions = new HashSet<BreakpointAddress>();
        graph.iterate(new INodeCallback<NaviNode>(){

            @Override
            public IterationMode next(NaviNode node) {
                if (node.getRawNode() instanceof INaviCodeNode) {
                    CStepOverHelper.stepInCodeNode((INaviCodeNode)node.getRawNode(), address, instructions);
                } else if (node.getRawNode() instanceof INaviFunctionNode) {
                    CStepOverHelper.stepInFunctionNode((INaviFunctionNode)node.getRawNode(), address, instructions);
                }
                return IterationMode.CONTINUE;
            }
        });
        return instructions;
    }
}

