/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadPanel.CThreadPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.CDebuggerToolbar;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.IToolbarPanelSynchronizerListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceLoggerListener;
import com.google.security.zynamics.zylib.general.ListenerProvider;

public final class CToolbarPanelSynchronizer {
    private final CDebuggerToolbar m_toolBar;
    private final CThreadPanel m_threadPanel;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();
    private final ThreadListener m_threadListener = new InternalThreadListener();
    private final ITraceLoggerListener m_traceListener = new InternalTraceListener();
    private final ListenerProvider<IToolbarPanelSynchronizerListener> m_listeners = new ListenerProvider();

    public CToolbarPanelSynchronizer(CDebuggerToolbar toolBar, CThreadPanel threadPanel, CDebugPerspectiveModel debugPerspectiveModel) {
        this.m_toolBar = Preconditions.checkNotNull(toolBar, "IE01524: Toolbar argument can not be null");
        this.m_threadPanel = Preconditions.checkNotNull(threadPanel, "IE01525: Thread panel argument can not be null");
        this.m_debugPerspectiveModel = Preconditions.checkNotNull(debugPerspectiveModel, "IE01526: Debug perspective model argument can not be null");
        IDebugger activeDebugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread activeThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
        this.synchronizeDebugger(null, this.m_debugPerspectiveModel.getCurrentSelectedDebugger());
        this.synchronizeThread(null, activeThread);
        this.m_debugPerspectiveModel.addListener(this.m_debugListener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
            this.m_debugPerspectiveModel.getTraceLogger(oldDebugger).removeListener(this.m_traceListener);
            this.synchronizeThread(oldDebugger.getProcessManager().getActiveThread(), null);
        }
        if (newDebugger != null) {
            newDebugger.getProcessManager().addListener(this.m_processListener);
            this.m_debugPerspectiveModel.getTraceLogger(newDebugger).addListener(this.m_traceListener);
            TargetInformation targetInformation = newDebugger.getProcessManager().getTargetInformation();
            if (targetInformation != null) {
                this.updateFromDebuggerOptions(targetInformation.getDebuggerOptions());
            }
            this.synchronizeThread(null, newDebugger.getProcessManager().getActiveThread());
        }
        this.m_toolBar.updateGui();
    }

    private void synchronizeThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.m_threadListener);
        }
        if (newThread != null) {
            newThread.addListener(this.m_threadListener);
        }
        this.m_toolBar.updateGui();
    }

    private void updateFromDebuggerOptions(DebuggerOptions options) {
        this.m_toolBar.updateFromDebuggerOptions(options);
        this.m_threadPanel.setVisible(options.canMultithread());
    }

    public void addListener(IToolbarPanelSynchronizerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_debugListener);
        IDebugger activeDebugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        this.synchronizeDebugger(activeDebugger, null);
    }

    public void removeListener(IToolbarPanelSynchronizerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalTraceListener
    implements ITraceLoggerListener {
        private InternalTraceListener() {
        }

        @Override
        public void addedBreakpoint() {
            CToolbarPanelSynchronizer.this.m_toolBar.updateGui();
        }

        @Override
        public void finished(TraceList list) {
            try {
                list.save();
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
                for (IToolbarPanelSynchronizerListener listener : CToolbarPanelSynchronizer.this.m_listeners) {
                    try {
                        listener.errorSavingTrace(list);
                    }
                    catch (Exception e2) {
                        CUtilityFunctions.logException(e2);
                    }
                }
            }
            CToolbarPanelSynchronizer.this.m_toolBar.updateGui();
        }

        @Override
        public void removedBreakpoint() {
            CToolbarPanelSynchronizer.this.m_toolBar.updateGui();
        }
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            CToolbarPanelSynchronizer.this.m_toolBar.updateGui();
        }
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CToolbarPanelSynchronizer.this.synchronizeThread(oldThread, newThread);
        }

        @Override
        public void changedTargetInformation(TargetInformation information) {
            CToolbarPanelSynchronizer.this.updateFromDebuggerOptions(information.getDebuggerOptions());
        }

        @Override
        public void detached() {
            CToolbarPanelSynchronizer.this.m_toolBar.updateGui();
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CToolbarPanelSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

