/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadPanel.CThreadPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.CDebuggerToolbar;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.CToolbarPanelSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.ToolbarPanel.IToolbarPanelSynchronizerListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public final class CToolbarPanel
extends JPanel {
    private static final long serialVersionUID = -3977448670006322794L;
    private final JFrame m_parent;
    private final CToolbarPanelSynchronizer m_synchronizer;
    private final IToolbarPanelSynchronizerListener m_internalSynchronizerListener = new InternalSynchronizerListener();
    private final CThreadPanel m_threadPanel;

    public CToolbarPanel(JFrame parent, CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(parent, "IE01523: Parent argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01522: Debug perspective model argument can not be null");
        this.m_parent = parent;
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.m_threadPanel = new CThreadPanel(debugPerspectiveModel);
        CDebuggerToolbar toolbar = new CDebuggerToolbar(debugPerspectiveModel);
        toolbarPanel.add((Component)toolbar, "West");
        toolbarPanel.add((Component)this.m_threadPanel, "Center");
        this.add((Component)toolbarPanel, "South");
        this.m_synchronizer = new CToolbarPanelSynchronizer(toolbar, this.m_threadPanel, debugPerspectiveModel);
        this.m_synchronizer.addListener(this.m_internalSynchronizerListener);
    }

    public void dispose() {
        this.m_threadPanel.dispose();
        this.m_synchronizer.removeListener(this.m_internalSynchronizerListener);
        this.m_synchronizer.dispose();
    }

    private class InternalSynchronizerListener
    implements IToolbarPanelSynchronizerListener {
        private InternalSynchronizerListener() {
        }

        @Override
        public void errorSavingTrace(TraceList list) {
            CMessageBox.showError(CToolbarPanel.this.m_parent, String.format("The trace '%s' could not be saved to the database.", list.getName()));
        }
    }
}

