/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel;

import com.google.security.zynamics.binnavi.Gui.Debug.CFadingColorGenerator;
import com.google.security.zynamics.binnavi.Gui.Debug.ThreadInformationPanel.CThreadInformationTable;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;

public final class CThreadInformationTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = -4591645811572405945L;
    private final JTable m_table;
    private final CFadingColorGenerator<TargetProcessThread> m_colorGenerator = new CFadingColorGenerator();

    public CThreadInformationTableRenderer(JTable table) {
        this.m_table = table;
    }

    public void addThread(final TargetProcessThread thread2) {
        this.m_colorGenerator.next(thread2);
        Timer timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Color newColor = CThreadInformationTableRenderer.this.m_colorGenerator.next(thread2);
                if (newColor.equals(Color.WHITE)) {
                    ((Timer)event.getSource()).stop();
                }
                CThreadInformationTableRenderer.this.m_table.updateUI();
            }
        });
        timer.start();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        TargetProcessThread module = ((CThreadInformationTable)table).getModel().getThreads().get(row);
        Color color = this.m_colorGenerator.getColor(module);
        this.setBackground(color == null ? Color.WHITE : color);
        return this;
    }
}

