/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Synchronizers;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Painters.CDebuggerPainter;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;

public final class CThreadEventSynchronizer {
    private final IDebugger m_debugger;
    private final ZyGraph m_graph;
    private final InternalThreadListener m_internalThreadListener = new InternalThreadListener();
    private final ProcessManagerListener m_processManagerListener = new ProcessManagerListenerAdapter(){

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CThreadEventSynchronizer.this.synchronizeThreads(oldThread, newThread);
        }
    };

    public CThreadEventSynchronizer(IDebugger debugger, ZyGraph graph) {
        Preconditions.checkNotNull(debugger, "IE01514: Debugger argument can not be null");
        Preconditions.checkNotNull(graph, "IE01515: Graph argument can not be null");
        this.m_debugger = debugger;
        this.m_graph = graph;
        this.synchronizeThreads(null, debugger.getProcessManager().getActiveThread());
        debugger.getProcessManager().addListener(this.m_processManagerListener);
    }

    private void paintProgramCounter(TargetProcessThread thread2) {
        if (thread2 == null) {
            CDebuggerPainter.clearDebuggerHighlighting(this.m_graph);
        } else {
            RelocatedAddress address = thread2.getCurrentAddress();
            if (address == null) {
                return;
            }
            CDebuggerPainter.updateDebuggerHighlighting(this.m_graph, this.m_debugger.memoryToFile(address), this.m_debugger.getModule(address));
        }
    }

    private void synchronizeThreads(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.m_internalThreadListener);
        }
        if (newThread == null) {
            CDebuggerPainter.clearDebuggerHighlighting(this.m_graph);
        } else {
            newThread.addListener(this.m_internalThreadListener);
        }
    }

    public void dispose() {
        this.synchronizeThreads(this.m_debugger.getProcessManager().getActiveThread(), null);
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void instructionPointerChanged(TargetProcessThread thread2, RelocatedAddress oldAddress) {
            CThreadEventSynchronizer.this.paintProgramCounter(thread2);
        }
    }
}

