/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.StatusLabel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.StatusLabel.CDebugEventListener;
import com.google.security.zynamics.binnavi.Gui.Debug.StatusLabel.CProcessListener;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.DebuggerProviderListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import java.util.Map;
import javax.swing.JLabel;

public final class CStatusLabelSynchronizer {
    private final BackEndDebuggerProvider m_debuggerProvider;
    private final ProcessManagerListener m_processListener;
    private final BreakpointManagerListener m_breakpointManagerListener = new InternalBreakpointManagerListener();
    private final DebuggerProviderListener m_debuggerProviderListener = new InternalDebuggerProviderListener();
    private final CDebugEventListener m_debugEventListener;
    private final JLabel m_label;

    public CStatusLabelSynchronizer(JLabel label, BackEndDebuggerProvider debuggerProvider) {
        this.m_label = Preconditions.checkNotNull(label, "IE01095: Label argument can not be null");
        this.m_debuggerProvider = Preconditions.checkNotNull(debuggerProvider, "IE01096: Debugger provider argument can not be null");
        this.m_processListener = new CProcessListener(label);
        this.m_debugEventListener = new CDebugEventListener(label);
        for (IDebugger debugger : debuggerProvider) {
            this.addListeners(debugger);
        }
        debuggerProvider.addListener(this.m_debuggerProviderListener);
    }

    private void addListeners(IDebugger debugger) {
        debugger.getProcessManager().addListener(this.m_processListener);
        debugger.getBreakpointManager().addListener(this.m_breakpointManagerListener);
        debugger.addListener(this.m_debugEventListener);
    }

    private void removeListeners(IDebugger debugger) {
        debugger.getProcessManager().removeListener(this.m_processListener);
        debugger.getBreakpointManager().removeListener(this.m_breakpointManagerListener);
        debugger.removeListener(this.m_debugEventListener);
    }

    public void dispose() {
        this.m_debuggerProvider.removeListener(this.m_debuggerProviderListener);
        for (IDebugger debugger : this.m_debuggerProvider) {
            this.removeListeners(debugger);
        }
    }

    private class InternalDebuggerProviderListener
    implements DebuggerProviderListener {
        private InternalDebuggerProviderListener() {
        }

        @Override
        public void debuggerAdded(BackEndDebuggerProvider provider, IDebugger debugger) {
            CStatusLabelSynchronizer.this.addListeners(debugger);
        }

        @Override
        public void debuggerRemoved(BackEndDebuggerProvider provider, IDebugger debugger) {
            CStatusLabelSynchronizer.this.removeListeners(debugger);
        }
    }

    private class InternalBreakpointManagerListener
    extends BreakpointManagerListenerAdapter {
        private InternalBreakpointManagerListener() {
        }

        @Override
        public void breakpointsStatusChanged(Map<Breakpoint, BreakpointStatus> breakpointToStatus, BreakpointStatus newStatus) {
            for (Breakpoint breakpoint : breakpointToStatus.keySet()) {
                if (newStatus != BreakpointStatus.BREAKPOINT_HIT) continue;
                CStatusLabelSynchronizer.this.m_label.setText(String.format("Breakpoint hit at address %s", breakpoint.getAddress().getAddress().getAddress().toHexString()));
            }
        }
    }
}

