/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.Loader;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.CRemoteSelectionDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListFilesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListProcessesReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processlist.ProcessDescription;
import com.google.security.zynamics.binnavi.debug.models.processlist.ProcessList;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFileSystem;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;
import java.io.File;
import javax.swing.JFrame;

public final class CRemoteFileBrowserLoader {
    private final JFrame m_parent;
    private final IDebugger m_debugger;
    private final LoaderThread m_loaderThread = new LoaderThread();
    private final InternalDebuggerListener m_listener = new InternalDebuggerListener();
    private int m_fileSystemRequest = 0;
    private int m_processRequest = 0;
    private int m_waitingFor = 2;
    private RemoteFileSystem m_fileSystem = null;
    private ProcessList m_processList = null;
    private boolean m_selectedTarget = false;

    public CRemoteFileBrowserLoader(JFrame parent, IDebugger debugger) {
        this.m_parent = Preconditions.checkNotNull(parent, "IE01498: Parent argument can not be null");
        this.m_debugger = Preconditions.checkNotNull(debugger, "IE01499: Debugger argument can not be null");
        this.m_debugger.addListener(this.m_listener);
    }

    private boolean keepWaiting() {
        return this.m_waitingFor != 0;
    }

    private void showRemoteBrowser() {
        CRemoteSelectionDialog dlg = CRemoteSelectionDialog.show(this.m_parent, this.m_debugger, this.m_fileSystem, this.m_processList);
        File selectedFile = dlg.getSelectedFile();
        ProcessDescription selectedProcess = dlg.getSelectedProcess();
        if (selectedFile != null) {
            try {
                this.m_debugger.selectFile(selectedFile.getAbsolutePath());
                this.m_selectedTarget = true;
            }
            catch (DebugExceptionWrapper e2) {
                CUtilityFunctions.logException(this.m_loaderThread.getException());
                String message2 = "E00039: Could not send target file request";
                String description = CUtilityFunctions.createDescription("BinNavi could not send the target file request to the debug client.", new String[]{"The connection to the debug client was closed before the request could be sent."}, new String[]{"There is still no debug target selected."});
                NaviErrorDialog.show(this.m_parent, "E00039: Could not send target file request", description, this.m_loaderThread.getException());
            }
        } else if (selectedProcess != null) {
            try {
                this.m_debugger.selectProcess(selectedProcess.getPID());
                this.m_selectedTarget = true;
            }
            catch (DebugExceptionWrapper e3) {
                CUtilityFunctions.logException(this.m_loaderThread.getException());
                String message3 = "E00040: Could not send target process request";
                String description = CUtilityFunctions.createDescription("BinNavi could not send the target process request to the debug client.", new String[]{"The connection to the debug client was closed before therequest could be sent."}, new String[]{"There is still not debug target selected."});
                NaviErrorDialog.show(this.m_parent, "E00040: Could not send target process request", description, this.m_loaderThread.getException());
            }
        }
    }

    public boolean load() {
        CProgressDialog.showEndless(this.m_parent, "Loading available drives", this.m_loaderThread);
        this.m_debugger.removeListener(this.m_listener);
        if (this.m_loaderThread.getException() != null) {
            CUtilityFunctions.logException(this.m_loaderThread.getException());
            String message2 = "E00038: Could not request remote file system information";
            String description = CUtilityFunctions.createDescription("BinNavi could not retrieve information about the remote file system.", new String[]{"The connection to the debug client was closed before the request could be sent."}, new String[]{"You can not select a target file from the remote system."});
            NaviErrorDialog.show(this.m_parent, "E00038: Could not request remote file system information", description, this.m_loaderThread.getException());
        } else if (this.m_fileSystem != null && this.m_processList != null) {
            this.showRemoteBrowser();
        }
        return this.m_selectedTarget;
    }

    private class LoaderThread
    extends CEndlessHelperThread {
        private LoaderThread() {
        }

        @Override
        protected void runExpensiveCommand() throws Exception {
            CRemoteFileBrowserLoader.this.m_fileSystemRequest = CRemoteFileBrowserLoader.this.m_debugger.requestFileSystem();
            CRemoteFileBrowserLoader.this.m_processRequest = CRemoteFileBrowserLoader.this.m_debugger.requestProcessList();
            while (CRemoteFileBrowserLoader.this.keepWaiting()) {
                Thread.sleep(100L);
            }
        }
    }

    private class InternalDebuggerListener
    extends DebugEventListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void debuggerClosed(int code2) {
            CRemoteFileBrowserLoader.this.m_waitingFor = 0;
        }

        @Override
        public void receivedReply(ListFilesReply reply) {
            if (CRemoteFileBrowserLoader.this.m_fileSystemRequest == reply.getId()) {
                CRemoteFileBrowserLoader.this.m_fileSystem = reply.getFileSystem();
                CRemoteFileBrowserLoader.this.m_waitingFor--;
            }
        }

        @Override
        public void receivedReply(ListProcessesReply reply) {
            if (CRemoteFileBrowserLoader.this.m_processRequest == reply.getId()) {
                CRemoteFileBrowserLoader.this.m_processList = reply.getProcessList();
                CRemoteFileBrowserLoader.this.m_waitingFor--;
            }
        }
    }
}

