/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.CProgressDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteFile;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteFileSystemView;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteFileView;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.Loader.CLoaderThread;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFileSystem;
import java.awt.Window;
import java.io.File;
import javax.swing.JFileChooser;

public class CRemoteFileBrowser
extends JFileChooser {
    private final Window parent;
    private final IDebugger debugger;

    public CRemoteFileBrowser(Window parent, IDebugger debugger, RemoteFileSystem fileSystem) {
        super(new CRemoteFileSystemView(fileSystem));
        this.parent = Preconditions.checkNotNull(parent, "IE01494: Parent argument can not be null");
        this.debugger = Preconditions.checkNotNull(debugger, "IE01495: Debugger argument can not be null");
        this.setFileView(new CRemoteFileView());
        String lastDir = ConfigManager.instance().getGeneralSettings().getLastDirectory();
        if (!lastDir.isEmpty()) {
            this.setCurrentDirectory(new CRemoteFile(lastDir, true));
        }
    }

    @Override
    public final void setCurrentDirectory(File directory) {
        if (this.debugger != null && this.getFileSystemView() != null && directory != null && !this.getCurrentDirectory().equals(directory)) {
            String normalizedDirectory = directory.getAbsolutePath();
            CLoaderThread thread2 = new CLoaderThread(this, this.debugger, normalizedDirectory);
            CProgressDialog.showEndless(this.parent, String.format("Loading content of directory '%s'", normalizedDirectory), thread2);
            ConfigManager.instance().getGeneralSettings().setLastDirectory(normalizedDirectory);
        }
        super.setCurrentDirectory(directory);
    }
}

