/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.FileBrowser.CRemoteFileBrowser;
import com.google.security.zynamics.binnavi.Gui.Debug.RemoteBrowser.ProcessBrowser.CProcessListPanel;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processlist.ProcessDescription;
import com.google.security.zynamics.binnavi.debug.models.processlist.ProcessList;
import com.google.security.zynamics.binnavi.debug.models.remotebrowser.RemoteFileSystem;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class CRemoteSelectionDialog
extends JDialog {
    private final JTabbedPane m_tabbedPane = new JTabbedPane();
    private final CRemoteFileBrowser m_browser;
    private final CProcessListPanel m_processPanel;
    private File m_selectedFile;
    private ProcessDescription m_selectedProcess;

    private CRemoteSelectionDialog(JFrame parent, IDebugger debugger, RemoteFileSystem fileList, ProcessList processList) {
        super((Window)parent, "Choose a file or a process", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(parent, "IE01489: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01490: Debugger argument can not be null");
        Preconditions.checkNotNull(fileList, "IE01491: File list argument can not be null");
        Preconditions.checkNotNull(processList, "IE01492: Process list argument can not be null");
        this.setLayout(new BorderLayout());
        new CDialogEscaper(this);
        this.m_browser = new CRemoteFileBrowser(this, debugger, fileList){

            @Override
            public void approveSelection() {
                CRemoteSelectionDialog.this.m_selectedFile = CRemoteSelectionDialog.this.m_browser.getSelectedFile();
                CRemoteSelectionDialog.this.dispose();
            }

            @Override
            public void cancelSelection() {
                CRemoteSelectionDialog.this.dispose();
            }
        };
        this.m_browser.setControlButtonsAreShown(false);
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(this.m_browser);
        this.m_tabbedPane.addTab("File", innerPanel);
        this.m_processPanel = new CProcessListPanel(processList);
        this.m_tabbedPane.addTab("Process", this.m_processPanel);
        this.add(this.m_tabbedPane);
        this.add((Component)new CPanelTwoButtons(new InternalListener(), "OK", "Cancel"), "South");
        this.pack();
    }

    public static CRemoteSelectionDialog show(JFrame parent, IDebugger debugger, RemoteFileSystem system, ProcessList list) {
        CRemoteSelectionDialog dlg = new CRemoteSelectionDialog(parent, debugger, system, list);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        return dlg;
    }

    public File getSelectedFile() {
        return this.m_selectedFile;
    }

    public ProcessDescription getSelectedProcess() {
        return this.m_selectedProcess;
    }

    private class InternalListener
    extends AbstractAction {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if ("OK".equals(event.getActionCommand())) {
                if (CRemoteSelectionDialog.this.m_tabbedPane.getSelectedIndex() == 0) {
                    CRemoteSelectionDialog.this.m_selectedFile = CRemoteSelectionDialog.this.m_browser.getSelectedFile();
                } else {
                    CRemoteSelectionDialog.this.m_selectedProcess = CRemoteSelectionDialog.this.m_processPanel.getSelectedProcess();
                }
            }
            CRemoteSelectionDialog.this.dispose();
        }
    }
}

