/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.CRegisterProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterDescription;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.zylib.gui.JRegisterView.JRegisterView;
import com.google.security.zynamics.zylib.types.lists.FilledList;

public final class CRegisterViewSynchronizer {
    private final JRegisterView m_registerView;
    private final CRegisterProvider m_dataProvider;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();
    private final ThreadListener m_threadListener = new InternalThreadListener();
    private final ProcessManagerListener m_processListener = new InternalProcessListener();

    public CRegisterViewSynchronizer(JRegisterView registerView, CRegisterProvider dataProvider, CDebugPerspectiveModel debugPerspectiveModel) {
        Preconditions.checkNotNull(registerView, "IE01479: Register view argument can not be null");
        Preconditions.checkNotNull(dataProvider, "IE01480: Data provider argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01481: Debug perspective model argument can not be null");
        this.m_registerView = registerView;
        this.m_dataProvider = dataProvider;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        IDebugger activeDebugger = debugPerspectiveModel.getCurrentSelectedDebugger();
        this.synchronizeDebugger(null, activeDebugger);
        debugPerspectiveModel.addListener(this.m_debugListener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger activeDebugger) {
        TargetProcessThread oldThread = null;
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_processListener);
            oldThread = oldDebugger.getProcessManager().getActiveThread();
        }
        if (activeDebugger != null) {
            TargetInformation targetInformation = activeDebugger.getProcessManager().getTargetInformation();
            if (targetInformation != null) {
                this.m_dataProvider.setRegisterDescription(targetInformation.getRegisters());
            }
            activeDebugger.getProcessManager().addListener(this.m_processListener);
            this.synchronizeThread(oldThread, activeDebugger.getProcessManager().getActiveThread());
        }
    }

    private void synchronizeThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.m_threadListener);
        }
        if (newThread != null) {
            this.m_dataProvider.setRegisterInformation(newThread.getRegisterValues());
            newThread.addListener(this.m_threadListener);
        }
        this.updateGui();
    }

    private void updateGui() {
        IDebugger activeDebugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread activeThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
        this.m_registerView.setEnabled(activeThread != null && activeDebugger != null && activeDebugger.isConnected());
    }

    public void dispose() {
        TargetProcessThread activeThread;
        this.m_debugPerspectiveModel.removeListener(this.m_debugListener);
        IDebugger activeDebugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread targetProcessThread = activeThread = activeDebugger == null ? null : activeDebugger.getProcessManager().getActiveThread();
        if (activeThread != null) {
            activeThread.removeListener(this.m_threadListener);
        }
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void registersChanged(TargetProcessThread thread2) {
            CRegisterViewSynchronizer.this.m_dataProvider.setRegisterInformation(thread2.getRegisterValues());
        }

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            CRegisterViewSynchronizer.this.updateGui();
        }
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CRegisterViewSynchronizer.this.synchronizeThread(oldThread, newThread);
        }

        @Override
        public void changedTargetInformation(TargetInformation information) {
            CRegisterViewSynchronizer.this.m_dataProvider.setRegisterDescription(information.getRegisters());
        }

        @Override
        public void detached() {
            CRegisterViewSynchronizer.this.m_dataProvider.setRegisterDescription(new FilledList<RegisterDescription>());
            CRegisterViewSynchronizer.this.m_dataProvider.setRegisterInformation(new FilledList<RegisterValue>());
            CRegisterViewSynchronizer.this.updateGui();
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            TargetInformation targetInformation;
            if (newDebugger != null && (targetInformation = newDebugger.getProcessManager().getTargetInformation()) != null) {
                CRegisterViewSynchronizer.this.m_dataProvider.setRegisterDescription(targetInformation.getRegisters());
            }
            CRegisterViewSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

