/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.IDataEnteredListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterDescription;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegisterModel;
import com.google.security.zynamics.zylib.gui.JRegisterView.IRegistersChangedListener;
import com.google.security.zynamics.zylib.gui.JRegisterView.RegisterInformationInternal;
import java.math.BigInteger;
import java.util.List;

public final class CRegisterProvider
implements IRegisterModel {
    private final ListenerProvider<IRegistersChangedListener> reglisteners = new ListenerProvider();
    private final ListenerProvider<IDataEnteredListener> enterlisteners = new ListenerProvider();
    private RegisterInformationInternal[] registerInformation = new RegisterInformationInternal[0];
    private List<RegisterDescription> m_information = null;

    private static void highlightChangedRegister(int counter, RegisterValue registerValue, RegisterInformationInternal[] oldRegisterInformation, RegisterInformationInternal[] newRegisterInformation) {
        if (counter < oldRegisterInformation.length) {
            if (!oldRegisterInformation[counter].getValue().equals(registerValue.getValue())) {
                newRegisterInformation[counter].setModified(true);
            }
        } else {
            newRegisterInformation[counter].setModified(true);
        }
    }

    private int findRegisterIndex(String registerName) {
        int counter = 0;
        for (RegisterInformationInternal info : this.registerInformation) {
            if (info.getRegisterName().equals(registerName)) {
                return counter;
            }
            ++counter;
        }
        return -1;
    }

    private RegisterDescription getDescription(String name) {
        for (RegisterDescription description : this.m_information) {
            if (!description.getName().equals(name)) continue;
            return description;
        }
        return null;
    }

    private void notifyRegisterChanged() {
        for (IRegistersChangedListener listener : this.reglisteners) {
            listener.registerDataChanged();
        }
    }

    private void notifyRegisterEntered(int index, BigInteger previousValue, BigInteger newValue) {
        for (IDataEnteredListener listener : this.enterlisteners) {
            listener.registerChanged(index, previousValue, newValue);
        }
    }

    public void addListener(IDataEnteredListener listener) {
        this.enterlisteners.addListener(listener);
    }

    @Override
    public void addListener(IRegistersChangedListener listener) {
        this.reglisteners.addListener(listener);
    }

    @Override
    public int getNumberOfRegisters() {
        return this.registerInformation.length;
    }

    @Override
    public RegisterInformationInternal[] getRegisterInformation() {
        return (RegisterInformationInternal[])this.registerInformation.clone();
    }

    @Override
    public RegisterInformationInternal getRegisterInformation(int index) {
        return this.registerInformation[index];
    }

    public void setRegisterDescription(List<RegisterDescription> information) {
        this.m_information = information;
    }

    public void setRegisterInformation(List<RegisterValue> information) {
        Preconditions.checkNotNull(information, "IE01475: Information argument can not be null");
        if (!information.isEmpty() && this.m_information == null) {
            throw new IllegalStateException("IE01124: Can not set register values if no target information is given");
        }
        RegisterInformationInternal[] oldRegisterInformation = this.registerInformation;
        RegisterInformationInternal[] newRegisterInformation = new RegisterInformationInternal[information.size()];
        int counter = 0;
        if (!information.isEmpty()) {
            Preconditions.checkNotNull(this.m_information, "IE01125: Target information should not be null at this point");
            for (RegisterValue registerValue : information) {
                RegisterDescription regInfo = this.getDescription(registerValue.getName());
                Preconditions.checkNotNull(regInfo, "IE01476: Unknown register");
                newRegisterInformation[counter] = new RegisterInformationInternal(regInfo.getName(), regInfo.getSize());
                newRegisterInformation[counter].setValue(registerValue.getValue());
                CRegisterProvider.highlightChangedRegister(counter, registerValue, oldRegisterInformation, newRegisterInformation);
                ++counter;
            }
        }
        this.registerInformation = newRegisterInformation;
        this.notifyRegisterChanged();
    }

    @Override
    public void setValue(String registerName, BigInteger editValue) {
        int index = this.findRegisterIndex(registerName);
        if (index == -1 || index >= this.registerInformation.length) {
            return;
        }
        BigInteger oldValue = this.registerInformation[index].getValue();
        this.registerInformation[index].setValue(editValue);
        this.notifyRegisterEntered(index, oldValue, editValue);
    }
}

