/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.Actions.CCopyRegisterValueAction;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.Actions.CGotoOffsetAction;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.Actions.CZoomToAddressAction;
import com.google.security.zynamics.binnavi.Gui.Debug.RegisterPanel.CRegisterProvider;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchAction;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.binnavi.disassembly.INaviCodeNode;
import com.google.security.zynamics.binnavi.disassembly.INaviFunctionNode;
import com.google.security.zynamics.binnavi.disassembly.INaviInstruction;
import com.google.security.zynamics.binnavi.disassembly.INaviViewNode;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.gui.JRegisterView.IMenuProvider;
import java.math.BigInteger;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class CRegisterMenuProvider
implements IMenuProvider {
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final CRegisterProvider m_dataProvider;

    public CRegisterMenuProvider(CDebugPerspectiveModel debugPerspectiveModel, CRegisterProvider dataProvider) {
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01219: Debug perspective model argument can not be null");
        Preconditions.checkNotNull(dataProvider, "IE01474: Data provider argument can not be null");
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.m_dataProvider = dataProvider;
    }

    private boolean containsAddress(INaviView rawView, long address) {
        for (INaviViewNode node : rawView.getGraph()) {
            if (node instanceof INaviFunctionNode) {
                INaviFunctionNode fnode = (INaviFunctionNode)node;
                if (fnode.getAddress().toLong() != address) continue;
                return true;
            }
            if (!(node instanceof INaviCodeNode)) continue;
            INaviCodeNode cnode = (INaviCodeNode)node;
            for (INaviInstruction instruction : cnode.getInstructions()) {
                if (instruction.getAddress().toLong() != address) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public JPopupMenu getRegisterMenu(int registerNumber) {
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        BigInteger value = this.m_dataProvider.getRegisterInformation(registerNumber).getValue();
        menu.add(CActionProxy.proxy(new CCopyRegisterValueAction(value.toString(16).toUpperCase())));
        MemorySection section = ProcessHelpers.getSectionWith(debugger.getProcessManager().getMemoryMap(), new CAddress(value));
        JMenuItem gotoAddress = menu.add(CActionProxy.proxy(new CGotoOffsetAction(this.m_debugPerspectiveModel, new CAddress(value))));
        gotoAddress.setEnabled(section != null);
        if (this.containsAddress(this.m_debugPerspectiveModel.getGraphModel().getGraph().getRawView(), value.longValue())) {
            menu.add(CActionProxy.proxy(new CZoomToAddressAction(this.m_debugPerspectiveModel.getGraphModel().getGraph(), new CAddress(value), debugger.getModule(new RelocatedAddress(new CAddress(value))))));
        } else {
            IViewContainer container = this.m_debugPerspectiveModel.getGraphModel().getViewContainer();
            menu.add(CActionProxy.proxy(new CSearchAction(this.m_debugPerspectiveModel.getGraphModel().getParent(), container, new CAddress(value))));
        }
        return menu;
    }
}

