/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.OptionsPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.IZyGraphDisplaySettingsListener;
import com.google.security.zynamics.binnavi.ZyGraph.Settings.ZyGraphDisplaySettingsListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;

public final class CRelocationCheckBox
extends JCheckBox {
    private static final long serialVersionUID = -6503942206525294243L;
    private final ZyGraph m_graph;
    private final IDebugger m_debugger;
    private final ItemListener m_internalItemListener = new InternalItemListener();
    private final IZyGraphDisplaySettingsListener m_internalSettingsListener = new InternalSettingsListener();

    public CRelocationCheckBox(ZyGraph graph, IDebugger debugger) {
        super("Show Relocated Offsets");
        Preconditions.checkNotNull(graph, "IE01469: Graph argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01470: Debugger argument can not be null");
        this.m_graph = graph;
        this.m_debugger = debugger;
        this.addItemListener(this.m_internalItemListener);
        graph.getSettings().getDisplaySettings().addListener(this.m_internalSettingsListener);
    }

    private class InternalSettingsListener
    extends ZyGraphDisplaySettingsListenerAdapter {
        private InternalSettingsListener() {
        }

        @Override
        public void changedShowMemoryAddresses(IDebugger debugger, boolean selected) {
            CRelocationCheckBox.this.setSelected(CRelocationCheckBox.this.m_graph.getSettings().getDisplaySettings().getShowMemoryAddresses(CRelocationCheckBox.this.m_debugger));
        }
    }

    private class InternalItemListener
    implements ItemListener {
        private InternalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            CRelocationCheckBox.this.m_graph.getSettings().getDisplaySettings().setShowMemoryAddresses(CRelocationCheckBox.this.m_debugger, CRelocationCheckBox.this.isSelected());
        }
    }
}

