/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import javax.swing.table.AbstractTableModel;

public final class CMissingOptionsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -7248890252459352865L;
    private final String[] m_columns = new String[]{"Option", "Status"};
    private final String[][] m_entries;

    public CMissingOptionsTableModel(DebuggerOptions options) {
        Preconditions.checkNotNull(options, "IE01465: Options argument can not be null");
        this.m_entries = new String[16][2];
        int index = 0;
        index = this.setRow(index, true, "Step Into");
        index = this.setRow(index, true, "Step Over");
        index = this.setRow(index, true, "Step to next block");
        index = this.setRow(index, true, "Trace mode");
        index = this.setRow(index, true, "Modify registers");
        index = this.setRow(index, options.canDetach(), "Detach from target");
        index = this.setRow(index, options.canMemmap(), "Show map of allocated memory");
        index = this.setRow(index, options.canValidMemory(), "Automatically find memory ranges");
        index = this.setRow(index, options.canMultithread(), "Multithreading support");
        index = this.setRow(index, options.canTerminate(), "Terminate target");
        index = this.setRow(index, options.canHalt(), "Halt target");
        index = this.setRow(index, options.mustHaltBeforeCommunicating(), "Halt before communicating");
        index = this.setRow(index, options.canSoftwareBreakpoint(), "Use software breakpoints");
        index = this.setRow(index, options.isStackAvailable(), "Stack view available");
        index = this.setRow(index, options.getBreakpointCounter(), "Maximum number of active breakpoints");
        this.setRow(index, options.getPageSize(), "Page size");
    }

    private int setRow(int index, boolean supported, String value) {
        this.m_entries[index][0] = value;
        this.m_entries[index][1] = supported ? "Supported" : "Not supported";
        return index + 1;
    }

    private int setRow(int index, int value, String description) {
        this.m_entries[index][0] = description;
        this.m_entries[index][1] = String.valueOf(value);
        return index + 1;
    }

    @Override
    public int getColumnCount() {
        return this.m_columns.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.m_columns[index];
    }

    @Override
    public int getRowCount() {
        return this.m_entries.length;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.m_entries[row][col];
    }
}

