/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.OptionsDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerException;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerExceptionHandlingAction;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class CExceptionSettingsPanel
extends JPanel {
    private final Map<JComboBox<String>, DebuggerException> m_comboboxMap = new HashMap<JComboBox<String>, DebuggerException>();

    public CExceptionSettingsPanel(DebuggerOptions options) {
        super(new BorderLayout());
        Preconditions.checkNotNull(options, "IE00267: Debugger options can not be null");
        JPanel innerPanel = new JPanel(new BorderLayout());
        JPanel componentPanel = new JPanel(new GridLayout(options.getExceptions().size(), 2));
        for (DebuggerException exception : options.getExceptions()) {
            JComboBox<String> comboBox = CExceptionSettingsPanel.buildRow(componentPanel, exception);
            comboBox.addItemListener(new ComboboxItemListener());
            this.m_comboboxMap.put(comboBox, exception);
        }
        innerPanel.add((Component)new JScrollPane(componentPanel), "North");
        this.add(innerPanel);
    }

    private static JComboBox<String> buildRow(JPanel componentPanel, DebuggerException exception) {
        componentPanel.add(new JLabel(exception.getExceptionName()));
        JComboBox<String> combobox = new JComboBox<String>();
        combobox.addItem(CExceptionSettingsPanel.getString(DebuggerExceptionHandlingAction.Continue));
        combobox.addItem(CExceptionSettingsPanel.getString(DebuggerExceptionHandlingAction.Halt));
        combobox.addItem(CExceptionSettingsPanel.getString(DebuggerExceptionHandlingAction.Ignore));
        combobox.setSelectedIndex(exception.getExceptionAction().getValue());
        componentPanel.add(combobox);
        return combobox;
    }

    private static String getString(DebuggerExceptionHandlingAction action) {
        switch (action) {
            case Continue: {
                return "Continue";
            }
            case Halt: {
                return "Halt";
            }
            case Ignore: {
                return "Ignore";
            }
        }
        throw new IllegalStateException("IE02295: Unknown debug exception handling action");
    }

    public Collection<DebuggerException> getExceptionSettings() {
        return this.m_comboboxMap.values();
    }

    private class ComboboxItemListener
    implements ItemListener {
        private ComboboxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            JComboBox combobox = (JComboBox)event.getSource();
            DebuggerException oldException = (DebuggerException)CExceptionSettingsPanel.this.m_comboboxMap.get(combobox);
            DebuggerExceptionHandlingAction exceptionAction = DebuggerExceptionHandlingAction.convertToHandlingAction(combobox.getSelectedIndex());
            CExceptionSettingsPanel.this.m_comboboxMap.put(combobox, new DebuggerException(oldException.getExceptionName(), oldException.getExceptionCode(), exceptionAction));
        }
    }
}

