/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.CFadingColorGenerator;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTable;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.DefaultTableCellRenderer;

public final class CModulesTableRenderer
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1773559764450713575L;
    private final JTable m_table;
    private final CFadingColorGenerator<MemoryModule> m_colorGenerator = new CFadingColorGenerator();

    public CModulesTableRenderer(JTable table) {
        this.m_table = Preconditions.checkNotNull(table, "IE02290: table argument can not be null");
    }

    public void addModule(final MemoryModule module) {
        Preconditions.checkNotNull(module, "IE02291: module argument can not be null");
        this.m_colorGenerator.next(module);
        Timer timer = new Timer(300, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Color newColor = CModulesTableRenderer.this.m_colorGenerator.next(module);
                if (newColor.equals(Color.WHITE)) {
                    ((Timer)event.getSource()).stop();
                }
                CModulesTableRenderer.this.m_table.updateUI();
            }
        });
        timer.start();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        MemoryModule module = (MemoryModule)((CModulesTable)table).getTreeTableModel().getModules().get(table.convertRowIndexToModel(row));
        Color color = this.m_colorGenerator.getColor(module);
        this.setBackground(color == null ? Color.WHITE : color);
        return this;
    }
}

