/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel;

import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilteredTableModel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.HexStringComparator;
import com.google.security.zynamics.zylib.general.comparators.LongComparator;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Semaphore;

public final class CModulesTableModel
extends CFilteredTableModel<MemoryModule> {
    private static final long serialVersionUID = 1926202151838011045L;
    private static final int NAME_COLUMN = 0;
    private static final int ADDRESS_COLUMN = 1;
    private static final int SIZE_COLUMN = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Name", "Base Address", "Size"};
    private final IFilledList<MemoryModule> m_modules = new FilledList<MemoryModule>();
    private List<MemoryModule> m_cachedValues = null;
    private final Semaphore m_cachedValuesSemaphore = new Semaphore(1);
    private boolean m_useFullPaths;

    public void addModule(MemoryModule module) {
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        this.m_modules.add(module);
        this.m_cachedValues = null;
        this.m_cachedValuesSemaphore.release();
        this.fireTableDataChanged();
    }

    @Override
    public void delete() {
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public IFilledList<MemoryModule> getModules() {
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        if (this.m_cachedValues == null) {
            IFilter<MemoryModule> filter = this.getFilter();
            this.m_cachedValues = filter == null ? this.m_modules : filter.get(this.m_modules);
        }
        FilledList<MemoryModule> returnValue = new FilledList<MemoryModule>((Collection<MemoryModule>)this.m_cachedValues);
        this.m_cachedValuesSemaphore.release();
        return returnValue;
    }

    @Override
    public int getRowCount() {
        return this.getModules().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, HexStringComparator>(1, new HexStringComparator()));
        sorters.add(new Pair<Integer, LongComparator>(2, new LongComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.m_useFullPaths ? ((MemoryModule)this.getModules().get(rowIndex)).getPath() : ((MemoryModule)this.getModules().get(rowIndex)).getName();
            }
            case 1: {
                return ((MemoryModule)this.getModules().get(rowIndex)).getBaseAddress().getAddress().toHexString();
            }
            case 2: {
                return ((MemoryModule)this.getModules().get(rowIndex)).getSize();
            }
        }
        return null;
    }

    public void removeModule(MemoryModule module) {
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        this.m_modules.remove(module);
        this.m_cachedValues = null;
        this.m_cachedValuesSemaphore.release();
        this.fireTableDataChanged();
    }

    public void reset() {
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        this.m_modules.clear();
        this.m_cachedValues = null;
        this.m_cachedValuesSemaphore.release();
        this.fireTableDataChanged();
    }

    @Override
    public void setFilter(IFilter<MemoryModule> filter) {
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        this.m_cachedValues = null;
        this.m_cachedValuesSemaphore.release();
        super.setFilter(filter);
    }

    public void setUseFullModulePaths(boolean useFullPaths) {
        this.m_useFullPaths = useFullPaths;
        this.m_cachedValuesSemaphore.acquireUninterruptibly();
        this.m_cachedValues = null;
        this.m_cachedValuesSemaphore.release();
        this.fireTableDataChanged();
    }
}

