/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CMemoryModuleFilterCreator;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesCheckBoxPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTable;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTableMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.CModulesTableModelSynchronizer;
import com.google.security.zynamics.binnavi.Gui.Debug.ModulesPanel.Help.CMemoryModuleFilterHelp;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CAbstractResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryModule;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;

public final class CModulesPanel
extends CAbstractResultsPanel {
    private static final long serialVersionUID = -6316724127804485173L;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final CModulesTable m_table = new CModulesTable();
    private final CModulesTableModelSynchronizer m_synchronizer;

    public CModulesPanel(CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01251: Debug perspective model argument can not be null");
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.add((Component)new CModulesCheckBoxPanel(this.m_table.getTreeTableModel()), "North");
        this.add(new CTablePanel<MemoryModule>(this.m_table, new CMemoryModuleFilterCreator(), new CMemoryModuleFilterHelp()));
        this.m_synchronizer = new CModulesTableModelSynchronizer(this.m_table, debugPerspectiveModel);
        this.m_table.addMouseListener(new InternalMouseListener());
    }

    private int getSelectionIndex(MouseEvent event) {
        return this.m_table.convertRowIndexToModel(this.m_table.rowAtPoint(event.getPoint()));
    }

    @Override
    public void dispose() {
        this.m_synchronizer.dispose();
    }

    @Override
    public String getTitle() {
        return "Modules";
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        private void displayPopupMenu(MouseEvent event) {
            int selectedIndex = CModulesPanel.this.getSelectionIndex(event);
            if (selectedIndex != -1) {
                MemoryModule memoryModule = (MemoryModule)CModulesPanel.this.m_table.getTreeTableModel().getModules().get(selectedIndex);
                CModulesTableMenu popupMenu = new CModulesTableMenu(SwingUtilities.getWindowAncestor(CModulesPanel.this), CModulesPanel.this.m_debugPerspectiveModel, memoryModule);
                popupMenu.show(CModulesPanel.this.m_table, event.getX(), event.getY());
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.displayPopupMenu(event);
            }
        }
    }
}

