/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemRangeDialog.CMemoryRangeDialog;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManager;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.swing.JFrame;

public final class CMemorySelectionFunctions {
    private CMemorySelectionFunctions() {
    }

    public static void askMemoryRange(CMemoryRangeDialog dlg, CDebugPerspectiveModel debugPerspectiveModel) {
        IDebugger debugger = debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger == null) {
            return;
        }
        dlg.setVisible(true);
        IAddress start = dlg.getStart();
        IAddress numberOfBytes = dlg.getBytes();
        if (start != null && numberOfBytes != null) {
            debugPerspectiveModel.setActiveMemoryAddress(start, true);
            ProcessManager pmanager = debugger.getProcessManager();
            pmanager.setMemoryMap(new MemoryMap(new FilledList<MemorySection>()));
            pmanager.getMemory().clear();
            ArrayList<MemorySection> sections = new ArrayList<MemorySection>();
            sections.add(new MemorySection(start, new CAddress(start.toBigInteger().add(numberOfBytes.toBigInteger()).subtract(BigInteger.ONE))));
            MemoryMap map = new MemoryMap(sections);
            pmanager.setMemoryMap(map);
        }
    }

    public static void refreshMemory(JFrame parent, IDebugger debugger, IAddress address, int size) {
        Preconditions.checkNotNull(parent, "IE01451: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01452: Debugger argument can not be null");
        if (!debugger.isConnected()) {
            return;
        }
        try {
            debugger.getMemoryMap();
            debugger.readMemory(address, size);
        }
        catch (DebugExceptionWrapper exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00080: Could not refresh memory";
            String innerDescription = CUtilityFunctions.createDescription("The memory list and the memory data could not be refreshed.", new String[]{"There was a problem with the connection to the debug client."}, new String[]{"The memory data was not refreshed."});
            NaviErrorDialog.show(parent, "E00080: Could not refresh memory", innerDescription, exception);
        }
    }
}

