/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.CMemoryRefreshButton;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.DebuggerOptions;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import javax.swing.Action;
import javax.swing.ImageIcon;

public final class CMemoryRefreshButtonSynchronizer {
    private final CMemoryRefreshButton m_refreshButton;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final Action m_defaultAction;
    private final Action m_askAction;
    private final ProcessManagerListener m_internalProcessListener = new InternalProcessListener();
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();

    public CMemoryRefreshButtonSynchronizer(CMemoryRefreshButton refreshButton, CDebugPerspectiveModel debugPerspectiveModel, Action defaultAction, Action askAction) {
        Preconditions.checkNotNull(refreshButton, "IE01442: Refresh button argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01443: Debug perspective model argument can not be null");
        Preconditions.checkNotNull(defaultAction, "IE01444: Default action argument can not be null");
        Preconditions.checkNotNull(askAction, "IE01445: Ask action argument can not be null");
        this.m_refreshButton = refreshButton;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        this.m_defaultAction = defaultAction;
        this.m_askAction = askAction;
        this.m_refreshButton.setAction(this.m_defaultAction);
        this.synchronizeDebugger(null, debugPerspectiveModel.getCurrentSelectedDebugger());
        debugPerspectiveModel.addListener(this.m_debugListener);
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_internalProcessListener);
        }
        if (newDebugger != null) {
            TargetInformation targetInformation = newDebugger.getProcessManager().getTargetInformation();
            if (targetInformation != null) {
                this.updateGuiFromOptions(targetInformation.getDebuggerOptions());
            }
            newDebugger.getProcessManager().addListener(this.m_internalProcessListener);
        }
        this.updateGui();
    }

    private void updateGui() {
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread thread2 = debugger == null ? null : debugger.getProcessManager().getActiveThread();
        boolean connected = debugger != null && debugger.isConnected();
        boolean suspended = connected && thread2 != null;
        this.m_refreshButton.setEnabled(suspended);
    }

    private void updateGuiFromOptions(DebuggerOptions options) {
        this.m_refreshButton.setAction(options.canValidMemory() ? this.m_defaultAction : this.m_askAction);
        this.m_refreshButton.setIcon(new ImageIcon(CMain.class.getResource("data/memoryupdate_up.jpg")));
    }

    public void dispose() {
        this.m_debugPerspectiveModel.removeListener(this.m_debugListener);
        this.synchronizeDebugger(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
    }

    private final class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CMemoryRefreshButtonSynchronizer.this.updateGui();
        }

        @Override
        public void changedTargetInformation(TargetInformation information) {
            CMemoryRefreshButtonSynchronizer.this.updateGuiFromOptions(information.getDebuggerOptions());
            CMemoryRefreshButtonSynchronizer.this.updateGui();
        }

        @Override
        public void detached() {
            CMemoryRefreshButtonSynchronizer.this.updateGui();
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CMemoryRefreshButtonSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
        }
    }
}

