/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SearchReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugEventListenerAdapter;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CEndlessHelperThread;

public final class CSearchWaiter
extends CEndlessHelperThread {
    private final IDebugger m_debugger;
    private final IAddress m_offset;
    private final int m_size;
    private final InternalDebuggerListener m_debuggerListener = new InternalDebuggerListener();
    private final InternalProcessListener m_processListener = new InternalProcessListener();
    private int m_packet;
    private boolean m_finished = false;
    private final byte[] m_data;
    private SearchReply m_reply;

    public CSearchWaiter(IDebugger debugger, IAddress offset, int size, byte[] data) {
        Preconditions.checkNotNull(debugger, "IE01437: Debugger argument can not be null");
        Preconditions.checkNotNull(offset, "IE01438: Offset argument can not be null");
        this.m_debugger = debugger;
        this.m_offset = offset;
        this.m_size = size;
        this.m_data = (byte[])data.clone();
        debugger.addListener(this.m_debuggerListener);
        debugger.getProcessManager().addListener(this.m_processListener);
    }

    private void removeListeners() {
        this.m_debugger.removeListener(this.m_debuggerListener);
        this.m_debugger.getProcessManager().removeListener(this.m_processListener);
    }

    private void stopWaiting() {
        this.m_finished = true;
        this.removeListeners();
        this.finish();
    }

    @Override
    protected void runExpensiveCommand() throws Exception {
        try {
            this.m_packet = this.m_debugger.search(this.m_offset, this.m_size, this.m_data);
        }
        catch (DebugExceptionWrapper exception) {
            this.removeListeners();
            throw exception;
        }
        while (!this.m_finished) {
            Thread.sleep(100L);
        }
    }

    @Override
    public void closeRequested() {
        this.stopWaiting();
    }

    public SearchReply getReply() {
        return this.m_reply;
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void detached() {
            CSearchWaiter.this.stopWaiting();
        }
    }

    private class InternalDebuggerListener
    extends DebugEventListenerAdapter {
        private InternalDebuggerListener() {
        }

        @Override
        public void receivedReply(SearchReply reply) {
            if (CSearchWaiter.this.m_packet == reply.getId()) {
                CSearchWaiter.this.m_reply = reply;
                CSearchWaiter.this.stopWaiting();
            }
        }
    }
}

