/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CExpressionEvaluationException;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.helpers.RelocationChecker;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.math.BigInteger;
import java.util.List;

public final class CExpressionEvaluator {
    private CExpressionEvaluator() {
    }

    private static BigInteger evaluateInteger(INaviOperandTreeNode node, IDebugger debugger, INaviModule module) {
        int longValue = (int)Long.valueOf(node.getValue()).longValue();
        if (RelocationChecker.needsRelocation(node, module)) {
            return debugger.fileToMemory(module, new UnrelocatedAddress(new CAddress(longValue))).getAddress().toBigInteger();
        }
        return BigInteger.valueOf(longValue);
    }

    private static BigInteger evaluateOperator(INaviOperandTreeNode node, ImmutableList<RegisterValue> registers, IDebugger debugger, INaviModule module) throws CExpressionEvaluationException {
        List<INaviOperandTreeNode> children = node.getChildren();
        BigInteger initial = CExpressionEvaluator.evaluateExpression(children.get(0), registers, debugger, module);
        for (int i2 = 1; i2 < children.size(); ++i2) {
            if (node.getValue().equals("+")) {
                initial = initial.add(CExpressionEvaluator.evaluateExpression(children.get(i2), registers, debugger, module));
                continue;
            }
            if (node.getValue().equals("-")) {
                initial = initial.subtract(CExpressionEvaluator.evaluateExpression(children.get(i2), registers, debugger, module));
                continue;
            }
            if (node.getValue().equals("*")) {
                initial = initial.multiply(CExpressionEvaluator.evaluateExpression(children.get(i2), registers, debugger, module));
                continue;
            }
            throw new CExpressionEvaluationException(String.format("Unknown operand '%s'", node.getValue()));
        }
        return initial;
    }

    private static BigInteger evaluateRegister(INaviOperandTreeNode node, ImmutableList<RegisterValue> registers) throws CExpressionEvaluationException {
        for (RegisterValue registerValue : registers) {
            if (!registerValue.getName().equalsIgnoreCase(node.getValue())) continue;
            return registerValue.getValue();
        }
        throw new CExpressionEvaluationException(String.format("Value of register %s could not be determined", node.getValue()));
    }

    public static BigInteger evaluateExpression(INaviOperandTreeNode node, ImmutableList<RegisterValue> registers, IDebugger debugger, INaviModule module) throws CExpressionEvaluationException {
        switch (node.getType()) {
            case IMMEDIATE_INTEGER: {
                return CExpressionEvaluator.evaluateInteger(node, debugger, module);
            }
            case REGISTER: {
                return CExpressionEvaluator.evaluateRegister(node, registers);
            }
            case OPERATOR: {
                return CExpressionEvaluator.evaluateOperator(node, registers, debugger, module);
            }
        }
        throw new IllegalStateException("IE00610: Unknown operand type");
    }
}

