/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations;

import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.CEvaluationException;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Implementations.IMemoryExpressionBinding;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.zylib.general.ByteHelpers;
import com.google.security.zynamics.zylib.general.memmanager.Memory;
import java.math.BigInteger;

public class CDefaultMemoryExpressionBinding
implements IMemoryExpressionBinding {
    private final TargetProcessThread m_thread;
    private final Memory m_memory;

    public CDefaultMemoryExpressionBinding(TargetProcessThread thread2, Memory memory) {
        this.m_thread = thread2;
        this.m_memory = memory;
    }

    @Override
    public BigInteger getValue(BigInteger address) throws CEvaluationException {
        if (this.m_memory.hasData(address.longValue(), 4)) {
            return BigInteger.valueOf(ByteHelpers.readDwordLittleEndian(this.m_memory.getData(address.longValue(), 4), 0));
        }
        throw new CEvaluationException(String.format("Unknown memory address %s", address.toString(16)));
    }

    @Override
    public BigInteger getValue(String register2) throws CEvaluationException {
        for (RegisterValue r2 : this.m_thread.getRegisterValues()) {
            if (!r2.getName().equalsIgnoreCase(register2)) continue;
            return r2.getValue();
        }
        throw new CEvaluationException(String.format("Unknown register name %s", register2));
    }
}

