/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.IMemoryViewerSynchronizerListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessManagerListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ThreadListenerAdapter;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ProcessManagerListener;
import com.google.security.zynamics.binnavi.debug.models.processmanager.interfaces.ThreadListener;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.TargetInformation;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.gui.JHexPanel.IHexPanelListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import java.util.Iterator;

public final class CMemoryViewerSynchronizer {
    private final JHexView m_hexView;
    private final CMemoryProvider m_provider;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final IDebugPerspectiveModelListener m_debugListener = new InternalDebugListener();
    private final ProcessManagerListener m_debuggerListener = new InternalProcessListener();
    private final ThreadListener m_threadListener = new InternalThreadListener();
    private final ListenerProvider<IMemoryViewerSynchronizerListener> m_listeners = new ListenerProvider();
    private final IHexPanelListener m_hexListener = new InternalHexListener();

    public CMemoryViewerSynchronizer(JHexView hexView, CMemoryProvider provider, CDebugPerspectiveModel debugPerspectiveModel) {
        Preconditions.checkNotNull(hexView, "IE01406: Hex view argument can not be null");
        Preconditions.checkNotNull(provider, "IE01407: Provider argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01408: Debug perspective model argument can not be null");
        this.m_hexView = hexView;
        this.m_provider = provider;
        this.m_debugPerspectiveModel = debugPerspectiveModel;
        debugPerspectiveModel.addListener(this.m_debugListener);
        this.synchronizeDebugger(null, this.m_debugPerspectiveModel.getCurrentSelectedDebugger());
        this.m_hexView.addHexListener(this.m_hexListener);
    }

    private IAddress getFirstAddress(MemoryMap memoryMap) {
        Iterator<MemorySection> iterator = memoryMap.iterator();
        if (iterator.hasNext()) {
            MemorySection memorySection = iterator.next();
            return memorySection.getStart();
        }
        return new CAddress(0L);
    }

    private boolean resizeData(IAddress address) {
        if (address == null) {
            return true;
        }
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        if (debugger != null) {
            MemorySection section = ProcessHelpers.getSectionWith(debugger.getProcessManager().getMemoryMap(), address);
            if (section == null) {
                this.m_debugPerspectiveModel.setActiveMemoryAddress(null, false);
                return false;
            }
            this.m_hexView.setBaseAddress(section.getStart().toLong());
            this.m_provider.setMemorySize(section.getSize());
            this.m_hexView.gotoOffset(address.toLong());
            this.updateGui();
            return true;
        }
        return true;
    }

    private void synchronizeDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
        TargetProcessThread activeThread;
        if (oldDebugger != null) {
            oldDebugger.getProcessManager().removeListener(this.m_debuggerListener);
            activeThread = oldDebugger.getProcessManager().getActiveThread();
            if (activeThread != null) {
                this.synchronizeThreads(activeThread, null);
            }
        }
        if (newDebugger != null) {
            newDebugger.getProcessManager().addListener(this.m_debuggerListener);
            this.m_provider.setDebugger(newDebugger);
            activeThread = newDebugger.getProcessManager().getActiveThread();
            if (activeThread != null) {
                this.synchronizeThreads(null, activeThread);
            }
        }
        this.updateGui();
    }

    private void synchronizeThreads(TargetProcessThread oldThread, TargetProcessThread newThread) {
        if (oldThread != null) {
            oldThread.removeListener(this.m_threadListener);
        }
        if (newThread != null) {
            newThread.addListener(this.m_threadListener);
        }
        this.updateGui();
    }

    private void updateGui() {
        IDebugger debugger = this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
        TargetProcessThread thread2 = debugger == null ? null : debugger.getProcessManager().getActiveThread();
        boolean connected = debugger != null && debugger.isConnected();
        boolean suspended = connected && thread2 != null;
        this.m_hexView.setEnabled(connected && suspended && this.m_provider.getDataLength() != 0);
        if (connected) {
            this.m_hexView.setDefinitionStatus(JHexView.DefinitionStatus.DEFINED);
        } else {
            this.m_provider.setMemorySize(0);
            this.m_hexView.setBaseAddress(0L);
            this.m_hexView.uncolorizeAll();
        }
    }

    public void addListener(IMemoryViewerSynchronizerListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void dispose() {
        this.m_hexView.removeHexListener(this.m_hexListener);
        this.synchronizeDebugger(this.m_debugPerspectiveModel.getCurrentSelectedDebugger(), null);
        this.m_debugPerspectiveModel.removeListener(this.m_debugListener);
    }

    public void removeListener(IMemoryViewerSynchronizerListener listener) {
        this.m_listeners.removeListener(listener);
    }

    private class InternalThreadListener
    extends ThreadListenerAdapter {
        private InternalThreadListener() {
        }

        @Override
        public void stateChanged(TargetProcessThread thread2) {
            CMemoryViewerSynchronizer.this.updateGui();
        }
    }

    private class InternalProcessListener
    extends ProcessManagerListenerAdapter {
        private InternalProcessListener() {
        }

        @Override
        public void changedActiveThread(TargetProcessThread oldThread, TargetProcessThread newThread) {
            CMemoryViewerSynchronizer.this.synchronizeThreads(oldThread, newThread);
            CMemoryViewerSynchronizer.this.updateGui();
        }

        @Override
        public void changedMemoryMap() {
            boolean showingData = CMemoryViewerSynchronizer.this.m_provider.getDataLength() != 0;
            long currentOffset = CMemoryViewerSynchronizer.this.m_hexView.getCurrentOffset();
            if (!CMemoryViewerSynchronizer.this.resizeData(new CAddress(CMemoryViewerSynchronizer.this.m_hexView.getCurrentOffset()))) {
                IDebugger debugger = CMemoryViewerSynchronizer.this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
                if (debugger != null && debugger.getProcessManager().getMemoryMap().getNumberOfSections() != 0) {
                    MemorySection section = debugger.getProcessManager().getMemoryMap().getSection(0);
                    CMemoryViewerSynchronizer.this.m_hexView.setBaseAddress(section.getStart().toLong());
                    CMemoryViewerSynchronizer.this.m_provider.setMemorySize(section.getSize());
                    CMemoryViewerSynchronizer.this.m_hexView.gotoOffset(section.getStart().toLong());
                }
                if (showingData) {
                    for (IMemoryViewerSynchronizerListener listener : CMemoryViewerSynchronizer.this.m_listeners) {
                        try {
                            listener.addressTurnedInvalid(currentOffset);
                        }
                        catch (Exception exception) {
                            CUtilityFunctions.logException(exception);
                        }
                    }
                }
            }
        }

        @Override
        public void changedTargetInformation(TargetInformation information) {
            CMemoryViewerSynchronizer.this.m_hexView.setAddressMode(information.getAddressSize() == 64 ? JHexView.AddressMode.BIT64 : JHexView.AddressMode.BIT32);
        }
    }

    private class InternalHexListener
    implements IHexPanelListener {
        private InternalHexListener() {
        }

        @Override
        public void selectionChanged(long start, long length) {
            CMemoryViewerSynchronizer.this.m_debugPerspectiveModel.setActiveMemoryAddress(new CAddress(CMemoryViewerSynchronizer.this.m_hexView.getCurrentOffset()), false);
        }
    }

    private class InternalDebugListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugListener() {
        }

        @Override
        public void changedActiveAddress(IAddress address, boolean focusMemoryWindow) {
            if (!CMemoryViewerSynchronizer.this.resizeData(address)) {
                for (IMemoryViewerSynchronizerListener listener : CMemoryViewerSynchronizer.this.m_listeners) {
                    try {
                        listener.requestedUnsectionedAddress(address);
                    }
                    catch (Exception exception) {
                        CUtilityFunctions.logException(exception);
                    }
                }
            } else if (focusMemoryWindow) {
                CMemoryViewerSynchronizer.this.m_hexView.requestFocusInWindow();
            }
        }

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            CMemoryViewerSynchronizer.this.synchronizeDebugger(oldDebugger, newDebugger);
            if (newDebugger != null) {
                CMemoryViewerSynchronizer.this.resizeData(CMemoryViewerSynchronizer.this.getFirstAddress(newDebugger.getProcessManager().getMemoryMap()));
            }
        }
    }
}

