/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryViewerSynchronizer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import java.awt.BorderLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class CMemoryViewer
extends JPanel {
    private static final long serialVersionUID = 1768975106918698292L;
    private final JHexView m_hexView = new JHexView();
    private final CMemoryProvider m_dataProvider = new CMemoryProvider();
    private final CMemoryViewerSynchronizer m_synchronizer;

    public CMemoryViewer(JFrame parent, CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(parent, "IE01404: Parent argument can not be null");
        Preconditions.checkNotNull(debugPerspectiveModel, "IE01405: Debugger argument can not be null");
        this.m_hexView.setData(this.m_dataProvider);
        this.m_hexView.setMenuCreator(new CMemoryMenu(parent, debugPerspectiveModel, this));
        this.m_hexView.setVisible(true);
        this.add(this.m_hexView);
        this.m_synchronizer = new CMemoryViewerSynchronizer(this.m_hexView, this.m_dataProvider, debugPerspectiveModel);
    }

    public void dispose() {
        this.m_synchronizer.dispose();
        this.m_hexView.dispose();
    }

    public JHexView getHexView() {
        return this.m_hexView;
    }

    @Override
    public boolean isEnabled() {
        return this.m_hexView.isEnabled();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.m_hexView.requestFocusInWindow();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_hexView.setEnabled(enabled);
    }
}

