/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CGotoAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.Actions.CSearchAction;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryPanel.CMemoryViewer;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.zylib.gui.JHexPanel.IHexPanelListener;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class CMemoryPanel
extends JPanel {
    private static final long serialVersionUID = -1010425056754096954L;
    private final CMemoryViewer m_hexView;
    private final JLabel m_offsetLabel = new JLabel();
    private final Action m_gotoAction;
    private final Action m_searchAction;
    private final IHexPanelListener m_hexPanelListener = new IHexPanelListener(){

        @Override
        public void selectionChanged(long start, long length) {
            CMemoryPanel.this.updateOffsetLabel();
        }
    };

    public CMemoryPanel(JFrame parent, CDebugPerspectiveModel debugger) {
        super(new BorderLayout());
        Preconditions.checkNotNull(parent, "IE01399: Parent argument can not be null");
        Preconditions.checkNotNull(debugger, "IE01400: Debugger argument can not be null");
        this.m_hexView = new CMemoryViewer(parent, debugger);
        this.m_searchAction = CActionProxy.proxy(new CSearchAction(parent, debugger, this.m_hexView));
        this.m_gotoAction = CActionProxy.proxy(new CGotoAction(parent, this.m_hexView, debugger));
        this.add(this.m_hexView);
        this.add((Component)this.m_offsetLabel, "South");
        this.updateOffsetLabel();
        this.m_hexView.getHexView().addHexListener(this.m_hexPanelListener);
        this.initHotkeys();
    }

    private void initHotkeys() {
        InputMap imap = this.m_hexView.getInputMap();
        InputMap windowImap = this.m_hexView.getInputMap(2);
        windowImap.put(HotKeys.GOTO_HK.getKeyStroke(), "GOTO");
        this.m_hexView.getActionMap().put("GOTO", this.m_gotoAction);
        imap.put(HotKeys.SEARCH_HK.getKeyStroke(), "SEARCH");
        this.m_hexView.getActionMap().put("SEARCH", this.m_searchAction);
    }

    private void updateOffsetLabel() {
        this.m_offsetLabel.setText(String.format("%s: %08X", "Current Offset", this.m_hexView.getHexView().getCurrentOffset()));
    }

    public void dispose() {
        this.m_hexView.getHexView().removeHexListener(this.m_hexPanelListener);
        this.m_hexView.dispose();
    }

    public CMemoryViewer getHexView() {
        return this.m_hexView;
    }

    public void updateGui(boolean connected, boolean suspended) {
        this.m_gotoAction.setEnabled(connected && suspended);
    }
}

