/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.MemRangeDialog;

import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigInteger;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public final class CMemoryRangeDialog
extends JDialog {
    private static final long serialVersionUID = -2434814129494159201L;
    private IAddress m_start = null;
    private IAddress m_bytes = null;
    private final JFormattedTextField m_startField;
    private final JFormattedTextField m_endField;

    public CMemoryRangeDialog(JFrame owner) {
        super(owner, "Enter a memory range", true);
        this.setLayout(new BorderLayout());
        this.setSize(400, 170);
        JLabel startLabel = new JLabel("Start Address (Hex)");
        JLabel endLabel = new JLabel("Number of Bytes (Hex)");
        this.m_startField = new JFormattedTextField(new CHexFormatter(8));
        this.m_endField = new JFormattedTextField(new CHexFormatter(8));
        JPanel labelPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.2;
        constraints.insets = new Insets(5, 5, 0, 0);
        constraints.fill = 2;
        labelPanel.add((Component)startLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 0, 0, 0);
        labelPanel.add((Component)this.m_startField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.2;
        constraints.insets = new Insets(5, 5, 0, 0);
        labelPanel.add((Component)endLabel, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.insets = new Insets(5, 0, 0, 0);
        labelPanel.add((Component)this.m_endField, constraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        JTextArea area = new JTextArea("Please enter a memory range to display. \nBe careful. Displaying invalid memory can crash the device.");
        area.setBorder(new EmptyBorder(0, 5, 0, 0));
        area.setEditable(false);
        topPanel.add((Component)area, "North");
        topPanel.add((Component)labelPanel, "Center");
        topPanel.setBorder(new TitledBorder(new LineBorder(Color.BLACK)));
        CPanelTwoButtons buttonPanel = new CPanelTwoButtons(new InternalListener(), "OK", "Cancel");
        this.add((Component)topPanel, "North");
        this.add((Component)buttonPanel, "South");
        this.m_startField.requestFocusInWindow();
        InputMap windowImap = this.getRootPane().getInputMap(2);
        windowImap.put(HotKeys.APPLY_HK.getKeyStroke(), "APPLY");
        this.getRootPane().getActionMap().put("APPLY", CActionProxy.proxy(new ApplyAction()));
        this.setLocationRelativeTo(null);
    }

    private void closeOk() {
        try {
            this.m_start = new CAddress(new BigInteger(this.m_startField.getText(), 16));
        }
        catch (NumberFormatException e2) {
            CMessageBox.showError(this, "You have entered an invalid start address.");
            return;
        }
        try {
            this.m_bytes = new CAddress(new BigInteger(this.m_endField.getText(), 16));
        }
        catch (NumberFormatException e3) {
            CMessageBox.showError(this, "You have entered an invalid end address.");
            return;
        }
        if (this.m_bytes.toBigInteger().equals(BigInteger.ZERO)) {
            CMessageBox.showError(this, "You have entered an invalid memory range.");
            return;
        }
        this.dispose();
    }

    public IAddress getBytes() {
        return this.m_bytes;
    }

    public IAddress getStart() {
        return this.m_start;
    }

    private class InternalListener
    implements ActionListener {
        private InternalListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                CMemoryRangeDialog.this.closeOk();
            } else {
                CMemoryRangeDialog.this.dispose();
            }
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = -5147201603251255198L;

        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CMemoryRangeDialog.this.closeOk();
        }
    }
}

