/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.History;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Exceptions.MaybeNullException;
import com.google.security.zynamics.binnavi.Gui.Debug.History.IHistoryStringBuilderListener;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AttachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.AuthenticationFailedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointConditionSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.BreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.CancelTargetSelectionReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DebuggerClosedUnexpectedlyReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.DetachReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.EchoBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ExceptionOccurredReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.HaltReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListFilesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ListProcessesReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.MemoryMapReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleLoadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ModuleUnloadedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ProcessStartReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.QueryDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ReadMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RegistersReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.RequestTargetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ResumeThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SearchReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectFileReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SelectProcessReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetDebuggerEventSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetExceptionSettingsReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SetRegisterReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SingleStepReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointHitReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointSetReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.StepBreakpointsRemovedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.SuspendThreadReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TargetInformationReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.TerminateReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadClosedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ThreadCreatedReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.ValidateMemoryReply;
import com.google.security.zynamics.binnavi.debug.connection.packets.replies.WriteMemoryReply;
import com.google.security.zynamics.binnavi.debug.debugger.DebugExceptionWrapper;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugEventListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessStart;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValue;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.RegisterValues;
import com.google.security.zynamics.binnavi.debug.models.targetinformation.ThreadRegisters;
import com.google.security.zynamics.binnavi.disassembly.RelocatedAddress;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.ListenerProvider;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.PairHelpers;
import com.google.security.zynamics.zylib.strings.CircularStringBuffer;
import com.google.security.zynamics.zylib.strings.Commafier;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionFilter;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import java.util.List;

public final class CHistoryStringBuilder {
    private final CircularStringBuffer m_string = new CircularStringBuffer(100);
    private IDebugger m_debugger;
    private final ListenerProvider<IHistoryStringBuilderListener> m_listeners = new ListenerProvider();
    private final IDebugEventListener m_listener = new IDebugEventListener(){

        private void updateText(String text2) {
            CHistoryStringBuilder.this.m_string.add(text2);
            for (IHistoryStringBuilderListener listener : CHistoryStringBuilder.this.m_listeners) {
                try {
                    listener.changedText(CHistoryStringBuilder.this.m_string.getText());
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                }
            }
        }

        @Override
        public void debugException(DebugExceptionWrapper debugException) {
        }

        @Override
        public void debuggerClosed(int errorCode) {
            this.updateText("SUCCESS: Debugger closed");
        }

        @Override
        public void receivedReply(AttachReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Attached to target";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Failed to attach to target (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(AuthenticationFailedReply reply) {
            this.updateText("ERROR: Could not authenticate the debug client");
        }

        @Override
        public void receivedReply(BreakpointConditionSetReply reply) {
        }

        @Override
        public void receivedReply(BreakpointHitReply reply) {
            try {
                IAddress programCounter = CHistoryStringBuilder.getProgramCounter(reply.getThreadId(), reply.getRegisterValues());
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Hit Breakpoint (Address: %s / TID: %d)", programCounter.toHexString(), reply.getThreadId()));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            catch (MaybeNullException e2) {
                this.updateText("ERROR: Hit Breakpoint (Could not determine event address)");
            }
        }

        @Override
        public void receivedReply(BreakpointSetReply reply) {
            String succString = CHistoryStringBuilder.getSuccessfulAddresses(reply.getAddresses());
            String errorString = CHistoryStringBuilder.getUnsuccessfulAddresses(reply.getAddresses());
            if (!succString.isEmpty()) {
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Breakpoints set at addresses %s", succString));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            if (!errorString.isEmpty()) {
                String string4 = String.valueOf("ERROR: ");
                String string5 = String.valueOf(String.format("Breakpoints could not be set at addresses %s", errorString));
                this.updateText(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }

        @Override
        public void receivedReply(BreakpointsRemovedReply reply) {
            String succString = CHistoryStringBuilder.getSuccessfulAddresses(reply.getAddresses());
            String errorString = CHistoryStringBuilder.getUnsuccessfulAddresses(reply.getAddresses());
            if (!succString.isEmpty()) {
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Breakpoints removed from addresses %s", succString));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            if (!errorString.isEmpty()) {
                String string4 = String.valueOf("ERROR: ");
                String string5 = String.valueOf(String.format("Breakpoints could not be removed from addresses %s", errorString));
                this.updateText(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }

        @Override
        public void receivedReply(CancelTargetSelectionReply reply) {
        }

        @Override
        public void receivedReply(DebuggerClosedUnexpectedlyReply reply) {
            String string2 = String.valueOf("ERROR: ");
            String string3 = String.valueOf(String.format("Debugger closed unexpectedly", new Object[0]));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(DetachReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Detached from target";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Failed to detach from target (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(EchoBreakpointHitReply reply) {
            try {
                IAddress programCounter = CHistoryStringBuilder.getProgramCounter(reply.getThreadId(), reply.getRegisterValues());
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Hit Echo Breakpoint (Address: %s / TID: %d)", programCounter.toHexString(), reply.getThreadId()));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            catch (MaybeNullException e2) {
                this.updateText("ERROR: Hit Echo Breakpoint (Could not determine event address)");
            }
        }

        @Override
        public void receivedReply(EchoBreakpointSetReply reply) {
            String succString = CHistoryStringBuilder.getSuccessfulAddresses(reply.getAddresses());
            String errorString = CHistoryStringBuilder.getUnsuccessfulAddresses(reply.getAddresses());
            if (!succString.isEmpty()) {
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Echo Breakpoints set at addresses %s", succString));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            if (!errorString.isEmpty()) {
                String string4 = String.valueOf("ERROR: ");
                String string5 = String.valueOf(String.format("Echo Breakpoints could not be set at addresses %s", errorString));
                this.updateText(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }

        @Override
        public void receivedReply(EchoBreakpointsRemovedReply reply) {
            String succString = CHistoryStringBuilder.getSuccessfulAddresses(reply.getAddresses());
            String errorString = CHistoryStringBuilder.getUnsuccessfulAddresses(reply.getAddresses());
            if (!succString.isEmpty()) {
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Echo Breakpoints removed from addresses %s", succString));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            if (!errorString.isEmpty()) {
                String string4 = String.valueOf("ERROR: ");
                String string5 = String.valueOf(String.format("Echo Breakpoints could not be removed from addresses %s", errorString));
                this.updateText(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }

        @Override
        public void receivedReply(ExceptionOccurredReply reply) {
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("Exception occured in the target process (Address: %s / TID: %d / Code: %d)", reply.getAddress().toString(), reply.getThreadId(), reply.getErrorCode()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(HaltReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Halted the target process";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Failed to halt the target process (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(ListFilesReply reply) {
        }

        @Override
        public void receivedReply(ListProcessesReply reply) {
        }

        @Override
        public void receivedReply(MemoryMapReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Received memory map of the target process";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Debug client could not determine the memory map of the target process (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(ModuleLoadedReply reply) {
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("Loaded module '%s'", reply.getModule().getName()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(ModuleUnloadedReply reply) {
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("Unloaded module '%s'", reply.getModule().getName()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(ProcessClosedReply reply) {
            this.updateText("SUCCESS: Target process closed");
        }

        @Override
        public void receivedReply(ProcessStartReply reply) {
            ProcessStart ps = reply.getProcessStart();
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("The new process was started: thread with TID %d was created and the module from %s was mapped to the base address %s", ps.getThread().getThreadId(), ps.getModule().getName(), ps.getModule().getBaseAddress().getAddress().toHexString()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(QueryDebuggerEventSettingsReply reply) {
            this.updateText("SUCCESS: Received query for debugger event settings");
        }

        @Override
        public void receivedReply(ReadMemoryReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Read %d bytes of memory from address %s", reply.getData().length, reply.getAddress().toHexString()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Failed to read memory (Error Code %d)", reply.getErrorCode()));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(RegistersReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Received register values of the target process";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Debug client could not determine the register values of the target process (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(RequestTargetReply reply) {
        }

        @Override
        public void receivedReply(ResumeReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Continued the target process";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Debug client could not continue the target process (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(ResumeThreadReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format(" Resumed thread with TID %d", reply.getThreadId()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Thread with TID %d could not be resumed (Error Code %d)", reply.getErrorCode(), reply.getThreadId()));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(SearchReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Received result of a memory search request";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Memory search could not be executed (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(SelectFileReply reply) {
        }

        @Override
        public void receivedReply(SelectProcessReply reply) {
        }

        @Override
        public void receivedReply(SetDebuggerEventSettingsReply reply) {
        }

        @Override
        public void receivedReply(SetExceptionSettingsReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Exception settings were set in the debugger", new Object[0]));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Unable to set exception settings in the debugger", new Object[0]));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(SetRegisterReply reply) {
            String string2;
            if (reply.success()) {
                string2 = "SUCCESS: Changed value of register";
            } else {
                String string3 = String.valueOf("ERROR: ");
                String string4 = String.valueOf(String.format("Value of the register could not be changed (Error Code %d)", reply.getErrorCode()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(SingleStepReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Executed a single step in thread %d (New PC address: %s)", reply.getThreadId(), reply.getAddress().getAddress().toHexString()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Single step could not be executed (Error Code %d)", reply.getErrorCode()));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(StepBreakpointHitReply reply) {
            try {
                String string2 = String.valueOf("SUCCESS: ");
                String string3 = String.valueOf(String.format("Stepped to address %s", CHistoryStringBuilder.getProgramCounter(reply.getThreadId(), reply.getRegisterValues()).toHexString()));
                this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
            }
            catch (MaybeNullException e2) {
                this.updateText("ERROR: Stepped to a new address (Could not determine event address)");
            }
        }

        @Override
        public void receivedReply(StepBreakpointSetReply reply) {
        }

        @Override
        public void receivedReply(StepBreakpointsRemovedReply reply) {
        }

        @Override
        public void receivedReply(SuspendThreadReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Suspended thread with TID %d", reply.getThreadId()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Thread with TID %d could not be suspended (Error Code %d)", reply.getErrorCode(), reply.getThreadId()));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(TargetInformationReply reply) {
            this.updateText("SUCCESS: Received target information");
        }

        @Override
        public void receivedReply(TerminateReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Terminated the target process", new Object[0]));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Target process could not terminated", new Object[0]));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(ThreadClosedReply reply) {
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("Thread with TID %d was closed", reply.getThreadId()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(ThreadCreatedReply reply) {
            String string2 = String.valueOf("SUCCESS: ");
            String string3 = String.valueOf(String.format("New thread with TID %d was created", reply.getThreadId()));
            this.updateText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
        }

        @Override
        public void receivedReply(ValidateMemoryReply reply) {
            String string2;
            if (reply.success()) {
                String string3 = String.valueOf("SUCCESS: ");
                String string4 = String.valueOf(String.format("Determined valid memory range between %s and %s", reply.getStart().toHexString(), reply.getEnd().toHexString()));
                string2 = string4.length() != 0 ? string3.concat(string4) : new String(string3);
            } else {
                String string5 = String.valueOf("ERROR: ");
                String string6 = String.valueOf(String.format("Memory range could not be determined (Error Code %d)", reply.getErrorCode()));
                string2 = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            }
            this.updateText(string2);
        }

        @Override
        public void receivedReply(WriteMemoryReply reply) {
        }
    };

    private static String getAddressString(List<Pair<RelocatedAddress, Integer>> addresses, ICollectionFilter<Pair<RelocatedAddress, Integer>> filter) {
        List validAddresses = PairHelpers.projectFirst(CollectionHelpers.filter(addresses, filter));
        List<String> addressStrings = CollectionHelpers.map(validAddresses, new ICollectionMapper<RelocatedAddress, String>(){

            @Override
            public String map(RelocatedAddress item) {
                return item.getAddress().toHexString();
            }
        });
        return Commafier.commafy(addressStrings);
    }

    private static IAddress getProgramCounter(long threadId, RegisterValues registerValues) throws MaybeNullException {
        for (ThreadRegisters threadRegisters : registerValues) {
            if (threadRegisters.getTid() != threadId) continue;
            for (RegisterValue registerValue : threadRegisters) {
                if (!registerValue.isPc()) continue;
                return new CAddress(registerValue.getValue());
            }
        }
        throw new MaybeNullException();
    }

    private static String getSuccessfulAddresses(List<Pair<RelocatedAddress, Integer>> addresses) {
        return CHistoryStringBuilder.getAddressString(addresses, new ICollectionFilter<Pair<RelocatedAddress, Integer>>(){

            @Override
            public boolean qualifies(Pair<RelocatedAddress, Integer> item) {
                return item.second() == 0;
            }
        });
    }

    private static String getUnsuccessfulAddresses(List<Pair<RelocatedAddress, Integer>> addresses) {
        return CHistoryStringBuilder.getAddressString(addresses, new ICollectionFilter<Pair<RelocatedAddress, Integer>>(){

            @Override
            public boolean qualifies(Pair<RelocatedAddress, Integer> item) {
                return item.second() != 0;
            }
        });
    }

    public void addListener(IHistoryStringBuilderListener listener) {
        this.m_listeners.addListener(listener);
    }

    public void removeListener(IHistoryStringBuilderListener listener) {
        this.m_listeners.removeListener(listener);
    }

    public void setDebugger(IDebugger debugger) {
        if (this.m_debugger != null) {
            this.m_debugger.removeListener(this.m_listener);
        }
        this.m_debugger = debugger;
        if (this.m_debugger != null) {
            this.m_debugger.addListener(this.m_listener);
        }
    }
}

