/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.History;

import com.google.security.zynamics.binnavi.Gui.Debug.History.CHistoryStringBuilder;
import com.google.security.zynamics.binnavi.Gui.Debug.History.IHistoryStringBuilderListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import javax.swing.JTextPane;

public class CDebuggerHistorySynchronizer {
    private final CHistoryStringBuilder m_historyStringBuilder = new CHistoryStringBuilder();
    private final CDebugPerspectiveModel m_model;
    private final JTextPane m_area;
    private final IDebugPerspectiveModelListener m_perspectiveListener = new CDebugPerspectiveModelListenerAdapter(){

        @Override
        public void changedActiveDebugger(IDebugger oldDebugger, IDebugger newDebugger) {
            if (CDebuggerHistorySynchronizer.this.m_area.isEnabled()) {
                CDebuggerHistorySynchronizer.this.synchronizeDebugger(newDebugger);
            }
        }
    };
    private final IHistoryStringBuilderListener m_builderListener = new InternalStringBuilderListener();

    public CDebuggerHistorySynchronizer(CDebugPerspectiveModel model, JTextPane area) {
        this.m_model = model;
        this.m_area = area;
        this.m_area.setEnabled(false);
        model.addListener(this.m_perspectiveListener);
        this.m_historyStringBuilder.addListener(this.m_builderListener);
    }

    private void synchronizeDebugger(IDebugger newDebugger) {
        this.m_historyStringBuilder.setDebugger(newDebugger);
    }

    public void dispose() {
        this.m_model.removeListener(this.m_perspectiveListener);
        this.m_historyStringBuilder.removeListener(this.m_builderListener);
        this.synchronizeDebugger(null);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.synchronizeDebugger(this.m_model.getCurrentSelectedDebugger());
        } else {
            this.synchronizeDebugger(null);
        }
        this.m_area.setEnabled(enabled);
    }

    private class InternalStringBuilderListener
    implements IHistoryStringBuilderListener {
        private InternalStringBuilderListener() {
        }

        @Override
        public void changedText(String text2) {
            CDebuggerHistorySynchronizer.this.m_area.setText(text2);
            CDebuggerHistorySynchronizer.this.m_area.setSelectionStart(CDebuggerHistorySynchronizer.this.m_area.getText().length());
        }
    }
}

