/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.GraphSelectionDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.GraphSelectionDialog.CGraphSelectionTableModel;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public final class CGraphSelectionDialog
extends JDialog {
    private INaviView m_selectionResult;
    private JTable m_table;
    private final List<INaviView> m_views;
    private final InternalListener m_listener = new InternalListener();

    public CGraphSelectionDialog(JFrame owner, List<INaviView> views) {
        super((Window)owner, "Select a graph", Dialog.ModalityType.APPLICATION_MODAL);
        Preconditions.checkNotNull(views, "IE01304: Function list can't be null");
        this.m_views = new ArrayList<INaviView>(views);
        this.createGui(views);
        new CDialogEscaper(this);
        this.setLocationRelativeTo(null);
    }

    private void closeDialog() {
        this.m_table.removeMouseListener(this.m_listener);
        this.setVisible(false);
        this.dispose();
    }

    private void createGui(List<INaviView> views) {
        this.setLayout(new BorderLayout());
        JTextArea field = new JTextArea("The debugger stopped at an instruction that does not belong to any open graphs.\nPlease select a graph from the list to continue debugging.");
        field.setEditable(false);
        this.add((Component)field, "North");
        this.m_table = new JTable(new CGraphSelectionTableModel(views));
        this.m_table.addMouseListener(this.m_listener);
        this.add((Component)new JScrollPane(this.m_table), "Center");
        CPanelTwoButtons panel = new CPanelTwoButtons(this.m_listener, "OK", "Cancel");
        this.add((Component)panel, "South");
        this.setSize(500, 300);
    }

    public INaviView getSelectionResult() {
        return this.m_selectionResult;
    }

    private class InternalListener
    extends MouseAdapter
    implements ActionListener {
        private InternalListener() {
        }

        private void setSelectedElement() {
            int selectedRow = CGraphSelectionDialog.this.m_table.getSelectedRow();
            if (selectedRow != -1) {
                CGraphSelectionDialog.this.m_selectionResult = (INaviView)CGraphSelectionDialog.this.m_views.get(selectedRow);
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("OK")) {
                this.setSelectedElement();
            }
            CGraphSelectionDialog.this.closeDialog();
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                this.setSelectedElement();
            }
            if (CGraphSelectionDialog.this.m_selectionResult != null) {
                CGraphSelectionDialog.this.closeDialog();
            }
        }
    }
}

