/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations.CTraceNodeFinder;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.Implementations.CTaggingFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.NaviNode;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JFrame;

public final class CTraceFunctions {
    private CTraceFunctions() {
    }

    public static void deleteTrace(final Window parent, final ITraceListProvider listProvider, int[] traces) {
        Preconditions.checkNotNull(parent, "IE01381: Parent argument can not be null");
        Preconditions.checkNotNull(listProvider, "IE01382: List provider argument can't be null");
        Preconditions.checkNotNull(traces, "IE01383: Traces argument can't be null");
        ArrayList<TraceList> traceObjects = new ArrayList<TraceList>();
        for (int trace2 : traces) {
            traceObjects.add(listProvider.getList(trace2));
        }
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following traces from the database?\n\n%s", CNameListGenerators.getNameList(traceObjects))) == 0) {
            Object object = traceObjects.iterator();
            while (object.hasNext()) {
                final TraceList trace3 = (TraceList)object.next();
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", true, false);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Deleting trace: ");
                        String string3 = String.valueOf(trace3.getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        try {
                            listProvider.removeList(trace3);
                            operation.getProgressPanel().next();
                        }
                        catch (CouldntDeleteException e2) {
                            CUtilityFunctions.logException(e2);
                            String innerMessage = "E00075: Could not delete trace list";
                            String innerDescription = CUtilityFunctions.createDescription(String.format("The trace list '%s' could not be deleted.", trace3.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The trace list was not deleted. You could try to delete the list again once the connection problem was resolved."});
                            NaviErrorDialog.show(parent, "E00075: Could not delete trace list", innerDescription, e2);
                        }
                        finally {
                            operation.stop();
                        }
                    }
                }.start();
            }
        }
    }

    public static void selectList(ZyGraph graph, TraceList list) {
        Preconditions.checkNotNull(graph, "IE01384: Graph argument can not be null");
        Preconditions.checkNotNull(list, "IE01385: List argument can not be null");
        graph.selectNodes(CTraceNodeFinder.getTraceNodes(graph, list), true);
    }

    public static void setBreakpoints(CDebugPerspectiveModel model, List<ITraceEvent> events) {
        IDebugger debugger = model.getCurrentSelectedDebugger();
        if (debugger == null) {
            return;
        }
        List<INaviModule> modules = debugger.getModules();
        HashSet<BreakpointAddress> addresses = new HashSet<BreakpointAddress>();
        for (ITraceEvent event : events) {
            BreakpointAddress address = event.getOffset();
            if (address.getModule() != null && (!modules.contains(address.getModule()) || debugger.getBreakpointManager().hasBreakpoint(BreakpointType.REGULAR, address))) continue;
            addresses.add(address);
        }
        debugger.getBreakpointManager().addBreakpoints(BreakpointType.REGULAR, addresses);
    }

    public static void setTraceDescription(JFrame parent, TraceList eventList, String description) {
        Preconditions.checkNotNull(eventList, "IE01387: Event list argument can't be null");
        Preconditions.checkNotNull(description, "IE01388: Description argument can't be null");
        try {
            eventList.setDescription(description);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00076: Could not change trace description";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The description of the trace list '%s' could not be changed.", eventList.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The trace list keeps its old description. You could try changing the description again once the connection problem was resolved."});
            NaviErrorDialog.show(parent, "E00076: Could not change trace description", innerDescription, e2);
        }
    }

    public static void setTraceName(JFrame parent, TraceList eventList, String name) {
        Preconditions.checkNotNull(eventList, "IE01390: Event list argument can't be null");
        Preconditions.checkNotNull(name, "IE01391: Name argument can't be null");
        try {
            eventList.setName(name);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00077: Could not change trace name";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The name of the trace list '%s' could not be changed.", eventList.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The trace list keeps its old name. You could try changing the name again once the connection problem was resolved."});
            NaviErrorDialog.show(parent, "E00077: Could not change trace name", innerDescription, e2);
        }
    }

    public static void tagList(JFrame parent, ZyGraph graph, TraceList list, CTag tag) {
        List<NaviNode> nodes = CTraceNodeFinder.getTraceNodes(graph, list);
        for (NaviNode node : nodes) {
            CTaggingFunctions.tagNode(parent, node, tag);
        }
    }
}

