/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations;

import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.zylib.types.common.CollectionHelpers;
import com.google.security.zynamics.zylib.types.common.ICollectionMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JFrame;

public final class CTraceCombinationFunctions {
    private CTraceCombinationFunctions() {
    }

    private static void createCombinedTrace(TraceList newTrace, List<TraceList> traces, Set<BreakpointAddress> addresses) {
        LinkedHashSet<BreakpointAddress> visitedAddresses = new LinkedHashSet<BreakpointAddress>();
        for (TraceList trace2 : traces) {
            for (ITraceEvent event : trace2) {
                BreakpointAddress address = event.getOffset();
                if (!addresses.contains(address) || visitedAddresses.contains(address)) continue;
                visitedAddresses.add(address);
                newTrace.addEvent(event);
            }
        }
    }

    private static Set<BreakpointAddress> getDifferenceAddresses(TraceList trace1, TraceList trace2) {
        ArrayList<TraceList> traces = Lists.newArrayList(trace1, trace2);
        List<Collection<BreakpointAddress>> traceAddresses = CTraceCombinationFunctions.getTraceAddresses(traces);
        LinkedHashSet<BreakpointAddress> addresses = new LinkedHashSet<BreakpointAddress>(traceAddresses.get(0));
        addresses.removeAll(traceAddresses.get(1));
        return addresses;
    }

    private static LinkedHashSet<BreakpointAddress> getIntersectedAddresses(List<TraceList> traces) {
        LinkedHashSet<BreakpointAddress> addresses = new LinkedHashSet<BreakpointAddress>();
        boolean first = true;
        for (Collection<BreakpointAddress> collection : CTraceCombinationFunctions.getTraceAddresses(traces)) {
            if (first) {
                addresses.addAll(collection);
                first = false;
                continue;
            }
            addresses.retainAll(collection);
        }
        return addresses;
    }

    private static List<Collection<BreakpointAddress>> getTraceAddresses(List<TraceList> traces) {
        return CollectionHelpers.map(traces, new ICollectionMapper<TraceList, Collection<BreakpointAddress>>(){

            @Override
            public Collection<BreakpointAddress> map(TraceList item) {
                return CollectionHelpers.map(item.getEvents(), new ICollectionMapper<ITraceEvent, BreakpointAddress>(){

                    @Override
                    public BreakpointAddress map(ITraceEvent item) {
                        return item.getOffset();
                    }
                });
            }
        });
    }

    private static LinkedHashSet<BreakpointAddress> getUnionizedAddresses(List<TraceList> traces) {
        LinkedHashSet<BreakpointAddress> addresses = new LinkedHashSet<BreakpointAddress>();
        for (Collection<BreakpointAddress> collection : CTraceCombinationFunctions.getTraceAddresses(traces)) {
            addresses.addAll(collection);
        }
        return addresses;
    }

    public static void differenceTraces(final JFrame parent, final ITraceListProvider provider, final TraceList trace1, final TraceList trace2) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                    operation.getProgressPanel().setMaximum(3);
                    operation.getProgressPanel().setText(String.format("Creating trace difference between '%s' and '%s'", trace1.getName(), trace2.getName()));
                    TraceList newTrace = provider.createTrace("Combined Trace", String.format("%s - %s", trace1.getName(), trace2.getName()));
                    operation.getProgressPanel().next();
                    CTraceCombinationFunctions.createCombinedTrace(newTrace, Lists.newArrayList(trace1, trace2), CTraceCombinationFunctions.getDifferenceAddresses(trace1, trace2));
                    operation.getProgressPanel().next();
                    newTrace.save();
                    operation.getProgressPanel().next();
                    operation.stop();
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00191: Could not combine debug traces";
                    String innerDescription = CUtilityFunctions.createDescription("The selected traces could not be combined into a larger trace.", new String[]{"There was a problem with the database connection."}, new String[]{"The trace list was not created. You could try to combine the lists again once the connection problem was resolved."});
                    NaviErrorDialog.show(parent, "E00191: Could not combine debug traces", innerDescription, e2);
                }
            }
        }.start();
    }

    public static void intersectTraces(final JFrame parent, final ITraceListProvider provider, final List<TraceList> traces) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                    operation.getProgressPanel().setMaximum(3);
                    operation.getProgressPanel().setText("Combining traces");
                    TraceList newTrace = provider.createTrace("Combined Trace", "");
                    operation.next();
                    CTraceCombinationFunctions.createCombinedTrace(newTrace, traces, CTraceCombinationFunctions.getIntersectedAddresses(traces));
                    operation.next();
                    newTrace.save();
                    operation.next();
                    operation.stop();
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00196: Could not combine debug traces";
                    String innerDescription = CUtilityFunctions.createDescription("The selected traces could not be combined into a larger trace.", new String[]{"There was a problem with the database connection."}, new String[]{"The trace list was not created. You could try to combine the lists again once the connection problem was resolved."});
                    NaviErrorDialog.show(parent, "E00196: Could not combine debug traces", innerDescription, e2);
                }
            }
        }.start();
    }

    public static void unionizeTraces(final JFrame parent, final ITraceListProvider provider, final List<TraceList> traces) {
        new Thread(){

            @Override
            public void run() {
                try {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, false);
                    operation.getProgressPanel().setMaximum(3);
                    operation.getProgressPanel().setText("Combining traces");
                    TraceList newTrace = provider.createTrace("Combined Trace", "");
                    operation.next();
                    CTraceCombinationFunctions.createCombinedTrace(newTrace, traces, CTraceCombinationFunctions.getUnionizedAddresses(traces));
                    operation.next();
                    newTrace.save();
                    operation.next();
                    operation.stop();
                }
                catch (CouldntSaveDataException e2) {
                    CUtilityFunctions.logException(e2);
                    String innerMessage = "E00197: Could not combine debug traces";
                    String innerDescription = CUtilityFunctions.createDescription("The selected traces could not be combined into a larger trace.", new String[]{"There was a problem with the database connection."}, new String[]{"The trace list was not created. You could try to combine the lists again once the connection problem was resolved."});
                    NaviErrorDialog.show(parent, "E00197: Could not combine debug traces", innerDescription, e2);
                }
            }
        }.start();
    }
}

