/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.primitives.Ints;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CDebugEventListPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTableMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventTableMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations.CTraceFunctions;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CAbstractResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.NodeTaggingTree.CTagsTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.gui.tables.TableHelpers;
import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public final class CTracesPanel
extends CAbstractResultsPanel {
    private static final long serialVersionUID = -7222540107360547882L;
    private final CDebugPerspectiveModel m_model;
    private final ZyGraph m_graph;
    private final ITraceListProvider m_traceProvider;
    private final CGraphPanel m_graphPanel;
    private final CDebugEventListPanel m_innerPanel;
    private final CEventListTable m_traceTable;
    private final CEventTable m_eventTable;

    public CTracesPanel(CDebugPerspectiveModel model, ZyGraph graph, ITraceListProvider traceProvider, CGraphPanel graphPanel) {
        super(new BorderLayout());
        this.m_model = model;
        this.m_graph = graph;
        this.m_traceProvider = traceProvider;
        this.m_graphPanel = graphPanel;
        this.m_innerPanel = new CDebugEventListPanel(traceProvider);
        this.add(this.m_innerPanel);
        this.m_traceTable = this.m_innerPanel.getTracesTable();
        this.m_eventTable = this.m_innerPanel.getEventsTable();
        this.m_traceTable.addMouseListener(new InternalTraceTableListener());
        this.m_eventTable.addMouseListener(new InternalEventsTableListener());
    }

    @Override
    public void dispose() {
        this.m_innerPanel.dispose();
    }

    @Override
    public String getTitle() {
        return "Traces";
    }

    private class InternalTraceTableListener
    extends MouseAdapter {
        private InternalTraceTableListener() {
        }

        private void showPopupMenu(MouseEvent event) {
            int minIndex;
            int[] rows;
            int mouseRow = CTracesPanel.this.m_traceTable.rowAtPoint(event.getPoint());
            if (mouseRow != -1 && Ints.asList(rows = CTracesPanel.this.m_traceTable.getSelectedRows()).indexOf(mouseRow) != -1) {
                CTracesPanel.this.m_traceTable.setRowSelectionInterval(mouseRow, mouseRow);
            }
            if ((minIndex = CTracesPanel.this.m_traceTable.getSelectionModel().getMinSelectionIndex()) != -1) {
                CTagsTree tagsTree = CTracesPanel.this.m_graphPanel.getTagsTree();
                CEventListTableMenu popupMenu = new CEventListTableMenu((JFrame)SwingUtilities.getWindowAncestor(CTracesPanel.this), CTracesPanel.this.m_traceTable, CTracesPanel.this.m_graph, CTracesPanel.this.m_traceProvider, tagsTree);
                popupMenu.show(CTracesPanel.this.m_traceTable, event.getX(), event.getY());
            }
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getButton() == 1) {
                TableHelpers.selectClickedRow(CTracesPanel.this.m_traceTable, event);
                int[] rows = CTracesPanel.this.m_traceTable.getConvertedSelectedRows();
                if (rows.length == 1) {
                    CTraceFunctions.selectList(CTracesPanel.this.m_graph, CTracesPanel.this.m_traceProvider.getList(rows[0]));
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }

    private class InternalEventsTableListener
    extends MouseAdapter {
        private InternalEventsTableListener() {
        }

        private List<ITraceEvent> getTraces(int[] rows) {
            ArrayList<ITraceEvent> events = new ArrayList<ITraceEvent>();
            for (int row : rows) {
                events.add(CTracesPanel.this.m_eventTable.getTreeTableModel().getEvents().get(row));
            }
            return events;
        }

        private void showPopupMenu(MouseEvent event) {
            int[] rows = CTracesPanel.this.m_eventTable.getConvertedSelectedRows();
            List<ITraceEvent> traces = this.getTraces(rows);
            CEventTableMenu menu = new CEventTableMenu(CTracesPanel.this.m_eventTable, CTracesPanel.this.m_model, traces);
            menu.show(CTracesPanel.this.m_eventTable, event.getX(), event.getY());
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                TableHelpers.selectClickedRow(CTracesPanel.this.m_eventTable, event);
                int[] rows = CTracesPanel.this.m_eventTable.getConvertedSelectedRows();
                if (rows.length == 1) {
                    ITraceEvent debugEvent = CTracesPanel.this.m_eventTable.getTreeTableModel().getEvents().get(rows[0]);
                    BreakpointAddress address = debugEvent.getOffset();
                    ZyZoomHelpers.zoomToAddress(CTracesPanel.this.m_graph, address.getAddress().getAddress(), address.getModule(), true);
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                this.showPopupMenu(event);
            }
        }
    }
}

