/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.security.zynamics.binnavi.debug.models.trace.TraceRegister;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import javax.swing.table.AbstractTableModel;

public final class CEventValueTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 4788903975097482416L;
    private static final String[] COLUMN_NAMES = new String[]{"Register", "Value", "Memory"};
    private static final int NAME_COLUMN = 0;
    private static final int VALUE_COLUMN = 1;
    public static final int MEMORY_COLUMN = 2;
    private ITraceEvent event = null;

    private String getMemoryString(byte[] memory) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < memory.length; ++i2) {
            stringBuffer.append(String.format("%02X", memory[i2]));
            if (i2 == memory.length - 1) continue;
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMN_NAMES[column];
    }

    public ITraceEvent getEvent() {
        return this.event;
    }

    @Override
    public int getRowCount() {
        if (this.event == null) {
            return 0;
        }
        return this.event.getRegisterValues().size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TraceRegister value = this.event.getRegisterValues().get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return value.getName();
            }
            case 1: {
                return value.getValue().toHexString();
            }
            case 2: {
                return this.getMemoryString(value.getMemory());
            }
        }
        throw new IllegalStateException("IE00609: Invalid column name");
    }

    public void setEvent(ITraceEvent event) {
        this.event = event;
        this.fireTableDataChanged();
    }
}

