/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilteredTableModel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.zylib.disassembly.IFunction;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.LongComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CEventTableModel
extends CFilteredTableModel<ITraceEvent> {
    private static final long serialVersionUID = 1388925809132144996L;
    private static final String[] COLUMNS = new String[]{"#", "Thread ID", "Module", "Address"};
    private static final int INDEX_COLUMN = 0;
    private static final int THREAD_COLUMN = 1;
    private static final int MODULE_COLUMN = 2;
    private static final int ADDRESS_COLUMN = 3;
    private TraceList m_eventList;
    private List<ITraceEvent> m_cachedValues = null;

    @Override
    public void delete() {
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
        }
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNS[column];
    }

    public List<ITraceEvent> getEvents() {
        List<ITraceEvent> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            localCachedValues = new ArrayList<ITraceEvent>();
            if (this.m_eventList == null) {
                this.m_cachedValues = localCachedValues;
                return localCachedValues;
            }
            IFilter<ITraceEvent> filter = this.getFilter();
            localCachedValues = filter == null ? this.m_eventList.getEvents() : filter.get(this.m_eventList.getEvents());
        }
        this.m_cachedValues = localCachedValues;
        return localCachedValues;
    }

    @Override
    public int getRowCount() {
        return this.getEvents().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        Pair<Integer, LongComparator> pair = new Pair<Integer, LongComparator>(1, new LongComparator());
        ArrayList list = new ArrayList();
        list.add(pair);
        return list;
    }

    @Override
    public Object getValueAt(int row, int col) {
        ITraceEvent debugEvent = this.getEvents().get(row);
        BreakpointAddress address = debugEvent.getOffset();
        switch (col) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return debugEvent.getThreadId();
            }
            case 2: {
                return address.getModule() == null ? "-" : address.getModule().getConfiguration().getName();
            }
            case 3: {
                IFunction function;
                if (address.getModule() == null) {
                    return address.getAddress().getAddress().toHexString();
                }
                IFunction iFunction = function = address.getModule().isLoaded() ? address.getModule().getContent().getFunctionContainer().getFunction(address.getAddress().getAddress()) : null;
                if (function == null) {
                    return address.getAddress().getAddress().toHexString();
                }
                return function.getName();
            }
        }
        throw new IllegalStateException("IE01121: Unknown column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setEventList(TraceList list) {
        this.m_eventList = list;
        this.m_cachedValues = null;
        this.fireTableDataChanged();
    }

    @Override
    public void setFilter(IFilter<ITraceEvent> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }
}

