/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CTableSearcherHelper;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Help.CEventListTableHelp;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Implementations.CTraceFunctions;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilteredTable;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.SwingUtilities;

public final class CEventListTable
extends CFilteredTable<TraceList> {
    private static final long serialVersionUID = 3558144500500581447L;
    private final ITraceListProvider m_traceProvider;

    public CEventListTable(ITraceListProvider traceProvider) {
        super(new CEventListTableModel(traceProvider), new CEventListTableHelp());
        this.m_traceProvider = Preconditions.checkNotNull(traceProvider, "IE01370: Trace list provider can't be null");
        this.getSelectionModel().setSelectionMode(2);
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.SEARCH_HK.getKeyStroke(), "SEARCH");
        this.getActionMap().put("SEARCH", CActionProxy.proxy(new SearchAction()));
        windowImap.put(HotKeys.DELETE_HK.getKeyStroke(), "DELETE");
        this.getActionMap().put("DELETE", CActionProxy.proxy(new DeleteAction()));
    }

    @Override
    public void dispose() {
        this.getTreeTableModel().delete();
    }

    public int[] getConvertedSelectedRows() {
        int[] selectedRows = super.getSelectedRows();
        int[] ret = new int[selectedRows.length];
        for (int i2 = 0; i2 < selectedRows.length; ++i2) {
            ret[i2] = this.convertRowIndexToModel(selectedRows[i2]);
        }
        return ret;
    }

    @Override
    public CEventListTableModel getTreeTableModel() {
        return (CEventListTableModel)super.getTreeTableModel();
    }

    private class SearchAction
    extends AbstractAction {
        private static final long serialVersionUID = 2696203205349441890L;

        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTableSearcherHelper.search(SwingUtilities.getWindowAncestor(CEventListTable.this), CEventListTable.this);
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private static final long serialVersionUID = 5699451707851809103L;

        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTraceFunctions.deleteTrace(SwingUtilities.getWindowAncestor(CEventListTable.this), CEventListTable.this.m_traceProvider, CEventListTable.this.getConvertedSelectedRows());
        }
    }
}

