/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.EventLists;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventListTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventValueTable;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CEventValueTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceEventsTableFilterMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceFilterCreator;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTraceMemoryDialog;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.CTracesTableFilterMenu;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Help.CTraceEventFilterHelp;
import com.google.security.zynamics.binnavi.Gui.Debug.EventLists.Help.CTraceFilterHelp;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilterFieldListener;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilteredTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CTracesFilterCreator;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceEvent;
import com.google.security.zynamics.binnavi.debug.models.trace.interfaces.ITraceListProvider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class CDebugEventListPanel
extends JPanel {
    private static final long serialVersionUID = -6320890258811231050L;
    private final CEventListTable m_tracesTable;
    private final CEventTable m_traceEventTable;
    private final CEventValueTable m_eventValueTable;
    private final CEventValueTableModel m_eventModel = new CEventValueTableModel();
    private final CTracesPanel m_tracesPanel;

    public CDebugEventListPanel(ITraceListProvider eventListManager) {
        super(new BorderLayout());
        Preconditions.checkNotNull(eventListManager, "IE01369: Event list manager argument can't be null");
        this.m_tracesTable = new CEventListTable(eventListManager);
        this.m_tracesTable.getSelectionModel().addListSelectionListener(new InternalSelectionListener());
        JPanel rightPanel = new JPanel(new BorderLayout());
        this.m_traceEventTable = new CEventTable(new CEventTableModel());
        this.m_traceEventTable.getSelectionModel().addListSelectionListener(new InternalEventSelectionListener());
        CTraceEventsPanel filteredPanel = new CTraceEventsPanel(this.m_traceEventTable);
        this.m_eventValueTable = new CEventValueTable(this.m_eventModel);
        this.m_eventValueTable.addMouseListener(new InternalMouseListener());
        JSplitPane splitPane1 = new JSplitPane(1, true, filteredPanel, new JScrollPane(this.m_eventValueTable));
        rightPanel.add((Component)splitPane1, "Center");
        splitPane1.setResizeWeight(0.5);
        this.m_tracesPanel = new CTracesPanel(this.m_tracesTable);
        JSplitPane splitPane = new JSplitPane(1, true, this.m_tracesPanel, rightPanel);
        this.add((Component)splitPane, "Center");
        splitPane.setResizeWeight(0.5);
    }

    public void dispose() {
        this.m_tracesPanel.dispose();
    }

    public CEventTable getEventsTable() {
        return this.m_traceEventTable;
    }

    public CEventListTable getTracesTable() {
        return this.m_tracesTable;
    }

    private class InternalSelectionListener
    implements ListSelectionListener {
        private InternalSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int first = CDebugEventListPanel.this.m_tracesTable.getSelectionModel().getMinSelectionIndex();
            if (first == -1) {
                CDebugEventListPanel.this.m_traceEventTable.setEventList(null);
                return;
            }
            boolean single = first == CDebugEventListPanel.this.m_tracesTable.getSelectionModel().getMaxSelectionIndex();
            CDebugEventListPanel.this.m_traceEventTable.setEnabled(single);
            if (single) {
                CEventListTableModel model = CDebugEventListPanel.this.m_tracesTable.getTreeTableModel();
                CDebugEventListPanel.this.m_traceEventTable.setEventList(model.getTraces().get(CDebugEventListPanel.this.m_tracesTable.convertRowIndexToModel(first)));
            }
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(event)) {
                Point clickPoint = event.getPoint();
                int row = CDebugEventListPanel.this.m_eventValueTable.rowAtPoint(clickPoint);
                int column = CDebugEventListPanel.this.m_eventValueTable.columnAtPoint(clickPoint);
                if (row != -1 && column == 2) {
                    byte[] data = CDebugEventListPanel.this.m_eventModel.getEvent().getRegisterValues().get(row).getMemory();
                    CTraceMemoryDialog.show(SwingUtilities.getWindowAncestor(CDebugEventListPanel.this.m_eventValueTable), data);
                }
            }
        }
    }

    private class InternalEventSelectionListener
    implements ListSelectionListener {
        private InternalEventSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            int first = CDebugEventListPanel.this.m_traceEventTable.getSelectionModel().getMinSelectionIndex();
            if (first == -1) {
                CDebugEventListPanel.this.m_eventValueTable.setEvent(null);
                return;
            }
            boolean single = first == CDebugEventListPanel.this.m_traceEventTable.getSelectionModel().getMaxSelectionIndex();
            CDebugEventListPanel.this.m_eventValueTable.setEnabled(single);
            if (single) {
                CEventTableModel model = CDebugEventListPanel.this.m_traceEventTable.getTreeTableModel();
                CDebugEventListPanel.this.m_eventValueTable.setEvent(model.getEvents().get(CDebugEventListPanel.this.m_traceEventTable.convertRowIndexToModel(first)));
            }
        }
    }

    private static final class CTracesPanel
    extends CTablePanel<TraceList> {
        private static final long serialVersionUID = -5321341959824234448L;
        private final InternalTracesTableMouseListener m_internalTracesTableMouseListener = new InternalTracesTableMouseListener();

        public CTracesPanel(IFilteredTable<TraceList> table) {
            super(table, new CTracesFilterCreator(), new CTraceFilterHelp());
            this.addListener(this.m_internalTracesTableMouseListener);
        }

        @Override
        protected void disposeInternal() {
            this.removeListener(this.m_internalTracesTableMouseListener);
        }

        private class InternalTracesTableMouseListener
        implements IFilterFieldListener {
            private InternalTracesTableMouseListener() {
            }

            private void showPopupMenu(MouseEvent event) {
                CTracesTableFilterMenu menu = new CTracesTableFilterMenu(CTracesPanel.this.getFilterField());
                menu.show(event.getComponent(), event.getX(), event.getY());
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }
        }
    }

    private static class CTraceEventsPanel
    extends CTablePanel<ITraceEvent> {
        private static final long serialVersionUID = 4765258747952807418L;
        private final InternalTracesTableMouseListener m_internalTracesTableMouseListener = new InternalTracesTableMouseListener();

        public CTraceEventsPanel(CEventTable table) {
            super(table, new CTraceFilterCreator(), new CTraceEventFilterHelp());
            this.addListener(this.m_internalTracesTableMouseListener);
        }

        @Override
        protected void disposeInternal() {
            this.removeListener(this.m_internalTracesTableMouseListener);
        }

        private class InternalTracesTableMouseListener
        implements IFilterFieldListener {
            private InternalTracesTableMouseListener() {
            }

            private void showPopupMenu(MouseEvent event) {
                CTraceEventsTableFilterMenu menu = new CTraceEventsTableFilterMenu(CTraceEventsPanel.this.getFilterField());
                menu.show(event.getComponent(), event.getX(), event.getY());
            }

            @Override
            public void mousePressed(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (event.isPopupTrigger()) {
                    this.showPopupMenu(event);
                }
            }
        }
    }
}

