/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.DebuggerSelectionPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.DebuggerSelectionPanel.CDebuggerComboBox;
import com.google.security.zynamics.binnavi.Gui.Debug.DebuggerSelectionPanel.CDebuggerWrapper;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.TargetProcessThread;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public final class CDebuggerSelectionPanelSynchronizer {
    private final CDebuggerComboBox m_debuggerBox;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final ItemListener m_internalItemListener = new InternalItemListener();

    public CDebuggerSelectionPanelSynchronizer(CDebuggerComboBox debuggerBox, CDebugPerspectiveModel debugPerspectiveModel) {
        this.m_debuggerBox = Preconditions.checkNotNull(debuggerBox, "IE01366: Debugger box can not be null");
        this.m_debugPerspectiveModel = Preconditions.checkNotNull(debugPerspectiveModel, "IE01367: Debug perspective model can not be null");
        this.m_debuggerBox.addItemListener(this.m_internalItemListener);
        if (this.m_debuggerBox.getItemCount() != 0) {
            IDebugger debugger = (IDebugger)this.m_debuggerBox.getSelectedItem().getObject();
            TargetProcessThread activeThread = debugger == null ? null : debugger.getProcessManager().getActiveThread();
            this.m_debugPerspectiveModel.setActiveDebugger(debugger);
            if (debugger != null) {
                debugger.getProcessManager().setActiveThread(activeThread);
            }
        }
    }

    public void dispose() {
        this.m_debuggerBox.removeItemListener(this.m_internalItemListener);
    }

    private class InternalItemListener
    implements ItemListener {
        private InternalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            CDebuggerWrapper mapper = CDebuggerSelectionPanelSynchronizer.this.m_debuggerBox.getSelectedItem();
            if (mapper == null) {
                CDebuggerSelectionPanelSynchronizer.this.m_debugPerspectiveModel.setActiveDebugger(null);
            } else {
                IDebugger debugger = (IDebugger)CDebuggerSelectionPanelSynchronizer.this.m_debuggerBox.getSelectedItem().getObject();
                CDebuggerSelectionPanelSynchronizer.this.m_debugPerspectiveModel.setActiveDebugger(debugger);
            }
        }
    }
}

