/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.CombinedMemoryPanel;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.CMemoryRefreshButtonPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.MemoryRefreshButton.IRefreshRangeProvider;
import com.google.security.zynamics.binnavi.Gui.Debug.MemorySelectionPanel.CMemorySelectionPanel;
import com.google.security.zynamics.binnavi.Gui.Debug.StackPanel.CStackView;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.BottomPanel.CAbstractResultsPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.CDebugPerspectiveModelListenerAdapter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Panels.IDebugPerspectiveModelListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemoryMap;
import com.google.security.zynamics.binnavi.debug.models.processmanager.MemorySection;
import com.google.security.zynamics.binnavi.debug.models.processmanager.ProcessHelpers;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import javax.swing.JFrame;

public final class CCombinedMemoryPanel
extends CAbstractResultsPanel {
    private static final long serialVersionUID = 668134668181649929L;
    private final CMemorySelectionPanel m_memorySelectionPanel;
    private final CStackView m_stackPanel;
    private final CDebugPerspectiveModel m_debugPerspectiveModel;
    private final IDebugPerspectiveModelListener m_internalListener = new InternalDebugPerspectiveModelListener();

    public CCombinedMemoryPanel(JFrame parent, CDebugPerspectiveModel debugPerspectiveModel) {
        super(new BorderLayout());
        Preconditions.checkNotNull(parent, "IE01361: Parent argument can not be null");
        this.m_debugPerspectiveModel = Preconditions.checkNotNull(debugPerspectiveModel, "IE01362: Debug perspective model argument can not be null");
        this.m_debugPerspectiveModel.addListener(this.m_internalListener);
        JideSplitPane pane = new JideSplitPane(1){
            private static final long serialVersionUID = -1326165812499630343L;

            @Override
            public void updateUI() {
            }
        };
        pane.setDividerSize(3);
        pane.setProportionalLayout(true);
        CMemoryRefreshButtonPanel refreshPanel = new CMemoryRefreshButtonPanel(parent, debugPerspectiveModel, new InternalRangeProvider(), new InternalStackRangeProvider());
        this.m_memorySelectionPanel = new CMemorySelectionPanel(parent, debugPerspectiveModel, refreshPanel);
        pane.addPane(this.m_memorySelectionPanel);
        this.m_stackPanel = new CStackView(debugPerspectiveModel);
        pane.addPane(this.m_stackPanel);
        this.add(pane);
    }

    @Override
    public void dispose() {
        this.m_memorySelectionPanel.dispose();
        this.m_stackPanel.dispose();
    }

    @Override
    public String getTitle() {
        return "Memory";
    }

    private class InternalStackRangeProvider
    implements IRefreshRangeProvider {
        private InternalStackRangeProvider() {
        }

        @Override
        public IAddress getAddress() {
            long startAddress = CCombinedMemoryPanel.this.m_stackPanel.getStackProvider().getStartAddress();
            return startAddress == -1L ? null : new CAddress(startAddress);
        }

        @Override
        public int getSize() {
            IDebugger activeDebugger = CCombinedMemoryPanel.this.m_debugPerspectiveModel.getCurrentSelectedDebugger();
            if (activeDebugger == null) {
                return 0;
            }
            MemoryMap memoryMap = activeDebugger.getProcessManager().getMemoryMap();
            if (memoryMap == null) {
                return 0;
            }
            MemorySection section = ProcessHelpers.getSectionWith(memoryMap, this.getAddress());
            return section == null ? 0 : section.getSize();
        }
    }

    private class InternalRangeProvider
    implements IRefreshRangeProvider {
        private InternalRangeProvider() {
        }

        @Override
        public IAddress getAddress() {
            return new CAddress(CCombinedMemoryPanel.this.m_memorySelectionPanel.getMemoryPanel().getHexView().getHexView().getFirstVisibleOffset());
        }

        @Override
        public int getSize() {
            return CCombinedMemoryPanel.this.m_memorySelectionPanel.getMemoryPanel().getHexView().getHexView().getVisibleBytes();
        }
    }

    private class InternalDebugPerspectiveModelListener
    extends CDebugPerspectiveModelListenerAdapter {
        private InternalDebugPerspectiveModelListener() {
        }

        @Override
        public void changedActiveAddress(IAddress address, boolean focusMemoryWindow) {
            if (address != null) {
                CCombinedMemoryPanel.this.notifyShow(CCombinedMemoryPanel.this.getComponent());
            }
        }
    }
}

