/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableHelpers;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.CViewHelpers;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.HashSet;

public final class CBreakpointSetFunctions {
    private CBreakpointSetFunctions() {
    }

    private static void checkArguments(BackEndDebuggerProvider debuggerProvider) {
        Preconditions.checkNotNull(debuggerProvider, "IE01357: Debugger provider argument can not be null");
    }

    private static void checkArguments(BackEndDebuggerProvider debuggerProvider, INaviView view) {
        CBreakpointSetFunctions.checkArguments(debuggerProvider);
        CBreakpointSetFunctions.checkArguments(view);
    }

    private static void checkArguments(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        CBreakpointSetFunctions.checkArguments(debuggerProvider);
        Preconditions.checkNotNull(rows, "IE01358: Rows argument can't be null");
    }

    private static void checkArguments(INaviView view) {
        Preconditions.checkNotNull(view, "IE01359: View argument can't be null");
    }

    private static void enableAll(BreakpointManager manager) {
        for (int i2 = 0; i2 < manager.getNumberOfBreakpoints(BreakpointType.REGULAR); ++i2) {
            manager.setBreakpointStatus(BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ENABLED, i2);
        }
    }

    private static void enableAllView(BreakpointManager manager, INaviView view) {
        HashSet<BreakpointAddress> addressesToEnable = new HashSet<BreakpointAddress>();
        for (int i2 = 0; i2 < manager.getNumberOfBreakpoints(BreakpointType.REGULAR); ++i2) {
            BreakpointAddress address = manager.getBreakpoint(BreakpointType.REGULAR, i2).getAddress();
            if (!CViewHelpers.containsAddress(view, address.getAddress())) continue;
            addressesToEnable.add(address);
        }
        manager.setBreakpointStatus(addressesToEnable, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ENABLED);
    }

    public static void enableAll(BackEndDebuggerProvider debuggerProvider) {
        CBreakpointSetFunctions.checkArguments(debuggerProvider);
        for (IDebugger debugger : debuggerProvider) {
            CBreakpointSetFunctions.enableAll(debugger.getBreakpointManager());
        }
    }

    public static void enableAllView(BackEndDebuggerProvider debuggerProvider, INaviView view) {
        CBreakpointSetFunctions.checkArguments(debuggerProvider, view);
        for (IDebugger debugger : debuggerProvider) {
            CBreakpointSetFunctions.enableAllView(debugger.getBreakpointManager(), view);
        }
    }

    public static void enableBreakpoints(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        CBreakpointSetFunctions.checkArguments(debuggerProvider, rows);
        for (int row : rows) {
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(debuggerProvider, row);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            int breakpointIndex = breakpoint.second();
            manager.setBreakpointStatus(BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_ENABLED, breakpointIndex);
        }
    }

    public static void setBreakpoints(IFilledList<Pair<IDebugger, INaviFunction>> targets) {
        Preconditions.checkNotNull(targets, "IE01261: Targets argument can not be null");
        for (Pair pair : targets) {
            if (((INaviFunction)pair.second()).getType() == FunctionType.IMPORT) continue;
            CGraphDebugger.setBreakpoint(((IDebugger)pair.first()).getBreakpointManager(), ((INaviFunction)pair.second()).getModule(), new UnrelocatedAddress(((INaviFunction)pair.second()).getAddress()));
        }
    }
}

