/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Implementations;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableHelpers;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Implementations.CGraphDebugger;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.UnrelocatedAddress;
import com.google.security.zynamics.binnavi.disassembly.views.CViewHelpers;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JFrame;

public final class CBreakpointRemoveFunctions {
    private CBreakpointRemoveFunctions() {
    }

    private static void removeAll(BreakpointManager manager) {
        HashSet<BreakpointAddress> addresses = new HashSet<BreakpointAddress>();
        for (Breakpoint breakpoint : manager.getBreakpoints(BreakpointType.REGULAR)) {
            addresses.add(breakpoint.getAddress());
        }
        CGraphDebugger.removeBreakpoints(addresses, manager);
    }

    private static void removeAllView(BreakpointManager manager, INaviView view) {
        HashSet<BreakpointAddress> addresses = new HashSet<BreakpointAddress>();
        for (int i2 = 0; i2 < manager.getNumberOfBreakpoints(BreakpointType.REGULAR); ++i2) {
            BreakpointAddress address = manager.getBreakpoint(BreakpointType.REGULAR, i2).getAddress();
            if (!CViewHelpers.containsAddress(view, address.getAddress())) continue;
            addresses.add(address);
        }
        CGraphDebugger.removeBreakpoints(addresses, manager);
    }

    public static void deleteBreakpoints(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        Preconditions.checkNotNull(debuggerProvider, "IE01886: Debugger provider argument can not be null");
        Preconditions.checkNotNull(rows, "IE02253: Rows argument can't be null");
        ArrayList<Pair<IDebugger, BreakpointAddress>> addresses = new ArrayList<Pair<IDebugger, BreakpointAddress>>();
        for (int row : rows) {
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(debuggerProvider, row);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            int breakpointIndex = breakpoint.second();
            addresses.add(new Pair<IDebugger, BreakpointAddress>(breakpoint.first(), manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress()));
        }
        Object object = addresses.iterator();
        while (object.hasNext()) {
            Pair p2 = (Pair)object.next();
            BreakpointManager manager = ((IDebugger)p2.first()).getBreakpointManager();
            BreakpointAddress address = (BreakpointAddress)p2.second();
            manager.setBreakpointStatus(Sets.newHashSet(address), BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DELETING);
        }
    }

    public static void disableAll(BackEndDebuggerProvider debuggerProvider) {
        Preconditions.checkNotNull(debuggerProvider, "IE01887: Debugger provider argument can not be null");
        for (IDebugger debugger : debuggerProvider) {
            BreakpointManager manager = debugger.getBreakpointManager();
            for (int i2 = 0; i2 < manager.getNumberOfBreakpoints(BreakpointType.REGULAR); ++i2) {
                manager.setBreakpointStatus(BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DISABLED, i2);
            }
        }
    }

    public static void disableAllView(BackEndDebuggerProvider debuggerProvider, INaviView view) {
        Preconditions.checkNotNull(debuggerProvider, "IE01889: Debugger provider argument can not be null");
        Preconditions.checkNotNull(view, "IE02009: View argument can't be null");
        for (IDebugger debugger : debuggerProvider) {
            BreakpointManager manager = debugger.getBreakpointManager();
            HashSet<BreakpointAddress> addressesToDisable = new HashSet<BreakpointAddress>();
            for (int i2 = 0; i2 < manager.getNumberOfBreakpoints(BreakpointType.REGULAR); ++i2) {
                BreakpointAddress address = manager.getBreakpoint(BreakpointType.REGULAR, i2).getAddress();
                if (!CViewHelpers.containsAddress(view, address.getAddress())) continue;
                addressesToDisable.add(address);
            }
            manager.setBreakpointStatus(addressesToDisable, BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DISABLED);
        }
    }

    public static void disableBreakpoints(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        Preconditions.checkNotNull(debuggerProvider, "IE01919: Debugger provider argument can not be null");
        Preconditions.checkNotNull(rows, "IE02254: Rows argument can't be null");
        for (int row : rows) {
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(debuggerProvider, row);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            int breakpointIndex = breakpoint.second();
            manager.setBreakpointStatus(BreakpointType.REGULAR, BreakpointStatus.BREAKPOINT_DISABLED, breakpointIndex);
        }
    }

    public static void removeAll(JFrame parent, BackEndDebuggerProvider debuggerProvider) {
        Preconditions.checkNotNull(parent, "IE01360: Parent argument can't be null");
        Preconditions.checkNotNull(debuggerProvider, "IE01921: Debugger provider argument can not be null");
        if (0 == CMessageBox.showYesNoCancelQuestion(parent, "Do you really want to remove all breakpoints?")) {
            for (IDebugger debugger : debuggerProvider) {
                CBreakpointRemoveFunctions.removeAll(debugger.getBreakpointManager());
            }
        }
    }

    public static void removeAllView(JFrame parent, BackEndDebuggerProvider debuggerProvider, INaviView view) {
        Preconditions.checkNotNull(parent, "IE01933: Parent argument can't be null");
        Preconditions.checkNotNull(debuggerProvider, "IE02251: Debugger provider argument can not be null");
        Preconditions.checkNotNull(view, "IE01956: View argument can't be null");
        if (0 == CMessageBox.showYesNoCancelQuestion(parent, "Do you really want to remove all breakpoints from this view?")) {
            for (IDebugger debugger : debuggerProvider) {
                CBreakpointRemoveFunctions.removeAllView(debugger.getBreakpointManager(), view);
            }
        }
    }

    public static void removeBreakpoints(IFilledList<Pair<IDebugger, INaviFunction>> targets) {
        Preconditions.checkNotNull(targets, "IE01260: Targets argument can not be null");
        for (Pair pair : targets) {
            CGraphDebugger.removeBreakpoint(((IDebugger)pair.first()).getBreakpointManager(), ((INaviFunction)pair.second()).getModule(), new UnrelocatedAddress(((INaviFunction)pair.second()).getAddress()));
        }
    }
}

