/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableHelpers;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.IGraphPanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CViewSearcher;
import com.google.security.zynamics.binnavi.Gui.WindowManager.CWindowManager;
import com.google.security.zynamics.binnavi.ZyGraph.Implementations.ZyZoomHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import java.awt.Window;

public final class CBreakpointFunctions {
    private CBreakpointFunctions() {
    }

    private static void checkArguments(BackEndDebuggerProvider debuggerProvider) {
        Preconditions.checkNotNull(debuggerProvider, "IE02235: Debugger provider argument can not be null");
    }

    private static void checkArguments(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        CBreakpointFunctions.checkArguments(debuggerProvider);
        Preconditions.checkNotNull(rows, "IE02250: Rows argument can't be null");
    }

    public static boolean allDisabled(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        CBreakpointFunctions.checkArguments(debuggerProvider, rows);
        for (int row : rows) {
            int breakpointIndex;
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(debuggerProvider, row);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            if (manager.getBreakpointStatus(BreakpointType.REGULAR, breakpointIndex = breakpoint.second().intValue()) == BreakpointStatus.BREAKPOINT_DISABLED) continue;
            return false;
        }
        return true;
    }

    public static boolean allNotDisabled(BackEndDebuggerProvider debuggerProvider, int[] rows) {
        CBreakpointFunctions.checkArguments(debuggerProvider, rows);
        for (int row : rows) {
            int breakpointIndex;
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(debuggerProvider, row);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            if (manager.getBreakpointStatus(BreakpointType.REGULAR, breakpointIndex = breakpoint.second().intValue()) != BreakpointStatus.BREAKPOINT_DISABLED) continue;
            return false;
        }
        return true;
    }

    public static void zoomToBreakpoint(Window parent, ZyGraph graph, IViewContainer container, BreakpointAddress address) {
        IAddress addr = address.getAddress().getAddress();
        if (!ZyZoomHelpers.zoomToAddress(graph, addr, address.getModule(), true)) {
            for (CGraphWindow window : CWindowManager.instance()) {
                for (IGraphPanel graphPanel : window) {
                    if (!ZyZoomHelpers.zoomToAddress(graphPanel.getModel().getGraph(), addr, address.getModule(), true)) continue;
                    window.activate(graphPanel);
                    window.toFront();
                    return;
                }
            }
            CViewSearcher.searchView(parent, container, addr);
        }
    }
}

