/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointConditionParser;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.InvalidFormulaException;
import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableCellEditor;

public class CConditionEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = -8534932082343485672L;
    private final JTextField inputField = new JTextField();
    private final DocumentListener m_documentListener = new InternalDocumentListener();

    public CConditionEditor() {
        this.inputField.getDocument().addDocumentListener(this.m_documentListener);
    }

    @Override
    public Object getCellEditorValue() {
        return this.inputField.getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.inputField.setText((String)value);
        return this.inputField;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            BreakpointConditionParser.evaluate(this.inputField.getText());
            this.fireEditingStopped();
        }
        catch (InvalidFormulaException invalidFormulaException) {
            // empty catch block
        }
        return true;
    }

    private class InternalDocumentListener
    implements DocumentListener {
        private InternalDocumentListener() {
        }

        private void updateColor() {
            try {
                BreakpointConditionParser.evaluate(CConditionEditor.this.inputField.getText());
                CConditionEditor.this.inputField.setBackground(Color.WHITE);
            }
            catch (InvalidFormulaException e2) {
                CConditionEditor.this.inputField.setBackground(Color.RED);
            }
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.updateColor();
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.updateColor();
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.updateColor();
        }
    }
}

