/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CDisableAllAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CDisableAllViewAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CEnableAllAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CEnableAllViewAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CRemoveAllAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CRemoveAllViewAction;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public final class CBreakpointToolbar
extends JToolBar {
    private static final long serialVersionUID = 3859654765731117058L;

    public CBreakpointToolbar(JFrame parent, BackEndDebuggerProvider debuggerProvider, INaviView view) {
        Preconditions.checkNotNull(parent, "IE01341: Parent argument can not be null");
        Preconditions.checkNotNull(debuggerProvider, "IE01342: Debugger provider argument can not be null");
        Preconditions.checkNotNull(view, "IE01343: View argument can not be null");
        this.setFloatable(false);
        this.createAndAddButtonToToolbar(new CRemoveAllAction(parent, debuggerProvider), "data/deleteallbreakpoints_up.png", "data/deleteallbreakpoints_hover.png", "data/deleteallbreakpoints_down.png");
        this.createAndAddButtonToToolbar(new CDisableAllAction(debuggerProvider), "data/disableallbreakpoints_up.png", "data/disableallbreakpoints_hover.png", "data/disableallbreakpoints_down.png");
        this.createAndAddButtonToToolbar(new CEnableAllAction(debuggerProvider), "data/enableallbreakpoints_up.png", "data/enableallbreakpoints_hover.png", "data/enableallbreakpoints_down.png");
        this.addSeparator();
        this.createAndAddButtonToToolbar(new CRemoveAllViewAction(parent, debuggerProvider, view), "data/deleteviewbreakpoints_up.png", "data/deleteviewbreakpoints_hover.png", "data/deleteviewbreakpoints_up.png");
        this.createAndAddButtonToToolbar(new CDisableAllViewAction(debuggerProvider, view), "data/disableviewbreakpoints_up.png", "data/disableviewbreakpoints_hover.png", "data/disableviewbreakpoints_down.png");
        this.createAndAddButtonToToolbar(new CEnableAllViewAction(debuggerProvider, view), "data/enableviewbreakpoints_up.png", "data/enableviewbreakpoints_hover.png", "data/enableviewbreakpoints_down.png");
    }

    private JButton createAndAddButtonToToolbar(AbstractAction action, String defaultIconPath, String rolloverIconPath, String pressedIconPath) {
        JButton button = this.add(CActionProxy.proxy(action));
        button.setBorder(new EmptyBorder(0, 0, 0, 0));
        button.setIcon(new ImageIcon(CMain.class.getResource(defaultIconPath)));
        button.setRolloverIcon(new ImageIcon(CMain.class.getResource(rolloverIconPath)));
        button.setPressedIcon(new ImageIcon(CMain.class.getResource(pressedIconPath)));
        return button;
    }
}

