/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.zylib.general.Pair;

public final class CBreakpointTableHelpers {
    private CBreakpointTableHelpers() {
    }

    public static Pair<IDebugger, Integer> findBreakpoint(BackEndDebuggerProvider debuggerProvider, int row) {
        Preconditions.checkNotNull(debuggerProvider, "IE01336: Debugger provider argument can't be null");
        Preconditions.checkArgument(row >= 0, "IE01337: Row arguments can not be negative");
        int breakpoints = 0;
        for (IDebugger debugger : debuggerProvider.getDebuggers()) {
            if (row >= breakpoints && row < breakpoints + debugger.getBreakpointManager().getNumberOfBreakpoints(BreakpointType.REGULAR)) {
                return new Pair<IDebugger, Integer>(debugger, row - breakpoints);
            }
            breakpoints += debugger.getBreakpointManager().getNumberOfBreakpoints(BreakpointType.REGULAR);
        }
        throw new IllegalArgumentException("IE01338: Invalid row number");
    }
}

