/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CDeleteAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CDisableAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CEnableAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Actions.CZoomBreakpointAction;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointStatusRenderer;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableHelpers;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CBreakpointTableModel;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.CConditionEditor;
import com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable.Implementations.CBreakpointFunctions;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.DebuggerProviderListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.Breakpoint;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointAddress;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointType;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.interfaces.BreakpointManagerListener;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.binnavi.yfileswrap.zygraph.ZyGraph;
import com.google.security.zynamics.zylib.general.Pair;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;

public final class CBreakpointTable
extends JTable {
    private static final long serialVersionUID = -7406128305807276782L;
    private final BackEndDebuggerProvider m_debuggerProvider;
    private final ZyGraph m_graph;
    private final IViewContainer m_viewContainer;
    private final CBreakpointTableModel m_tableModel;
    private final InternalBreakpointManagerListener m_breakpointManagerListener = new InternalBreakpointManagerListener();
    private final DebuggerProviderListener m_debuggerListener = new InternalDebuggerListener();

    public CBreakpointTable(BackEndDebuggerProvider debuggerProvider, ZyGraph graph, IViewContainer viewContainer) {
        this.m_debuggerProvider = Preconditions.checkNotNull(debuggerProvider, "IE01335: Debugger provider can't be null");
        this.m_graph = Preconditions.checkNotNull(graph, "IE02093: Graph argument can not be null");
        this.m_viewContainer = Preconditions.checkNotNull(viewContainer, "IE02099: View container argument can not be null");
        this.m_tableModel = new CBreakpointTableModel(debuggerProvider);
        this.setModel(this.m_tableModel);
        for (IDebugger debugger : debuggerProvider.getDebuggers()) {
            this.addDebuggerListeners(debugger);
        }
        debuggerProvider.addListener(this.m_debuggerListener);
        this.getSelectionModel().setSelectionMode(2);
        this.getColumnModel().getColumn(0).setCellRenderer(new CBreakpointStatusRenderer());
        DefaultTableCellRenderer tcrColumn = new DefaultTableCellRenderer();
        tcrColumn.setHorizontalAlignment(0);
        this.getColumnModel().getColumn(2).setCellRenderer(tcrColumn);
        this.getColumnModel().getColumn(3).setCellRenderer(tcrColumn);
        this.getColumnModel().getColumn(4).setCellRenderer(tcrColumn);
        this.getColumnModel().getColumn(1).setCellRenderer(tcrColumn);
        this.getColumnModel().getColumn(5).setCellEditor(new CConditionEditor());
        this.addMouseListener(new InternalMouseListener());
    }

    private void addDebuggerListeners(IDebugger debugger) {
        BreakpointManager manager = debugger.getBreakpointManager();
        manager.addListener(this.m_breakpointManagerListener);
    }

    private void removeDebuggerListeners(IDebugger debugger) {
        BreakpointManager manager = debugger.getBreakpointManager();
        manager.removeListener(this.m_breakpointManagerListener);
    }

    private void showPopupMenu(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        int column = this.columnAtPoint(event.getPoint());
        int[] rows = this.getSelectedRows();
        if (rows.length == 0 || rows.length == 1) {
            this.changeSelection(row, column, false, false);
            rows = this.getSelectedRows();
        }
        JPopupMenu menu = new JPopupMenu();
        menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteAction(this.m_debuggerProvider, rows))));
        if (CBreakpointFunctions.allDisabled(this.m_debuggerProvider, rows)) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CEnableAction(this.m_debuggerProvider, rows))));
        } else if (CBreakpointFunctions.allNotDisabled(this.m_debuggerProvider, rows)) {
            menu.add(new JMenuItem(CActionProxy.proxy(new CDisableAction(this.m_debuggerProvider, rows))));
        }
        if (rows.length == 1) {
            menu.addSeparator();
            Pair<IDebugger, Integer> breakpoint = CBreakpointTableHelpers.findBreakpoint(this.m_debuggerProvider, rows[0]);
            BreakpointManager manager = breakpoint.first().getBreakpointManager();
            int breakpointIndex = breakpoint.second();
            BreakpointAddress address = manager.getBreakpoint(BreakpointType.REGULAR, breakpointIndex).getAddress();
            menu.add(new JMenuItem(CActionProxy.proxy(new CZoomBreakpointAction(SwingUtilities.windowForComponent(this), this.m_graph, this.m_viewContainer, address))));
        }
        menu.show(event.getComponent(), event.getX(), event.getY());
    }

    public void dispose() {
        for (IDebugger debugger : this.m_debuggerProvider.getDebuggers()) {
            this.removeDebuggerListeners(debugger);
        }
        this.m_debuggerProvider.removeListener(this.m_debuggerListener);
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CBreakpointTable.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CBreakpointTable.this.showPopupMenu(event);
            }
        }
    }

    private class InternalDebuggerListener
    implements DebuggerProviderListener {
        private InternalDebuggerListener() {
        }

        @Override
        public void debuggerAdded(BackEndDebuggerProvider provider, IDebugger debugger) {
            CBreakpointTable.this.addDebuggerListeners(debugger);
        }

        @Override
        public void debuggerRemoved(BackEndDebuggerProvider provider, IDebugger debugger) {
            CBreakpointTable.this.removeDebuggerListeners(debugger);
        }
    }

    private class InternalBreakpointManagerListener
    implements BreakpointManagerListener {
        private InternalBreakpointManagerListener() {
        }

        private void handleTableChangeTrigger(Collection<Breakpoint> breakpoints) {
            boolean needsTableChange = false;
            for (Breakpoint breakpoint : breakpoints) {
                if (breakpoint.getType() != BreakpointType.REGULAR) continue;
                needsTableChange = true;
                break;
            }
            if (needsTableChange) {
                CBreakpointTable.this.m_tableModel.fireTableDataChanged();
            }
        }

        @Override
        public void breakpointsAdded(List<Breakpoint> breakpoints) {
            this.handleTableChangeTrigger(breakpoints);
        }

        @Override
        public void breakpointsConditionChanged(Set<Breakpoint> breakpoints) {
            this.handleTableChangeTrigger(breakpoints);
        }

        @Override
        public void breakpointsDescriptionChanged(Set<Breakpoint> breakpoints) {
            this.handleTableChangeTrigger(breakpoints);
        }

        @Override
        public void breakpointsRemoved(Set<Breakpoint> breakpoints) {
            this.handleTableChangeTrigger(breakpoints);
        }

        @Override
        public void breakpointsStatusChanged(Map<Breakpoint, BreakpointStatus> breakpointsToStatus, BreakpointStatus status) {
            this.handleTableChangeTrigger(breakpointsToStatus.keySet());
        }
    }
}

