/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.BreakpointTable;

import com.google.security.zynamics.binnavi.debug.models.breakpoints.BreakpointManager;
import com.google.security.zynamics.binnavi.debug.models.breakpoints.enums.BreakpointStatus;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public final class CBreakpointStatusRenderer
extends JLabel
implements TableCellRenderer {
    public CBreakpointStatusRenderer() {
        this.setOpaque(true);
    }

    private static String getText(BreakpointStatus breakpointStatus) {
        switch (breakpointStatus) {
            case BREAKPOINT_ACTIVE: {
                return "Active";
            }
            case BREAKPOINT_INACTIVE: {
                return "Inactive";
            }
            case BREAKPOINT_ENABLED: {
                return "Enabled";
            }
            case BREAKPOINT_DISABLED: {
                return "Disabled";
            }
            case BREAKPOINT_HIT: {
                return "Hit";
            }
            case BREAKPOINT_INVALID: {
                return "Invalid";
            }
            case BREAKPOINT_DELETING: {
                return "Deleting";
            }
        }
        throw new IllegalStateException("IE01117: Unknown breakpoint status");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        super.setHorizontalAlignment(0);
        BreakpointStatus breakpointStatus = (BreakpointStatus)((Object)object);
        this.setForeground(Color.BLACK);
        this.setBackground(BreakpointManager.getBreakpointColor(breakpointStatus));
        this.setText(CBreakpointStatusRenderer.getText(breakpointStatus));
        this.setBorder(BorderFactory.createMatteBorder(2, 5, 2, 5, isSelected ? table.getSelectionBackground() : table.getBackground()));
        return this;
    }
}

