/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Bookmarks;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Debug.Bookmarks.CBookmarkTableHelpers;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.DebuggerProviderListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.CBookmark;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.IBookmarkManagerListener;
import com.google.security.zynamics.zylib.general.Triple;
import javax.swing.table.AbstractTableModel;

public final class CBookmarkTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -1596072260232647317L;
    private static final int DEBUGGER_COLUMN = 0;
    private static final int ADDRESS_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Debugger", "Address", "Description"};
    private final InternalBookmarkListener m_listener = new InternalBookmarkListener();
    private final DebuggerProviderListener m_debuggerListener = new InternalDebuggerListener();
    private final BackEndDebuggerProvider m_debuggerProvider;

    public CBookmarkTableModel(BackEndDebuggerProvider debuggerProvider) {
        this.m_debuggerProvider = Preconditions.checkNotNull(debuggerProvider, "IE01325: Bookmarks manager can't be null");
        this.initializeListeners();
    }

    private int countBookmarks() {
        int bookmarks = 0;
        for (IDebugger debugger : this.m_debuggerProvider) {
            bookmarks += debugger.getBookmarkManager().getNumberOfBookmarks();
        }
        return bookmarks;
    }

    private String getBookmarkAddress(int row) {
        Triple<IDebugger, BookmarkManager, Integer> bookmarkTriple = CBookmarkTableHelpers.findBookmark(this.m_debuggerProvider, row);
        BookmarkManager manager = bookmarkTriple.second();
        int index = bookmarkTriple.third();
        return manager.getBookmark(index).getAddress().toHexString();
    }

    private String getBookmarkDescription(int row) {
        Triple<IDebugger, BookmarkManager, Integer> bookmarkTriple = CBookmarkTableHelpers.findBookmark(this.m_debuggerProvider, row);
        BookmarkManager manager = bookmarkTriple.second();
        int index = bookmarkTriple.third();
        return manager.getBookmark(index).getDescription();
    }

    private String getDebugger(int row) {
        Triple<IDebugger, BookmarkManager, Integer> bookmarkTriple = CBookmarkTableHelpers.findBookmark(this.m_debuggerProvider, row);
        return bookmarkTriple.first().getPrintableString();
    }

    private void initializeListeners() {
        for (IDebugger debugger : this.m_debuggerProvider) {
            debugger.getBookmarkManager().addListener(this.m_listener);
        }
        this.m_debuggerProvider.addListener(this.m_debuggerListener);
    }

    private void removeListeners() {
        for (IDebugger debugger : this.m_debuggerProvider) {
            debugger.getBookmarkManager().removeListener(this.m_listener);
        }
        this.m_debuggerProvider.removeListener(this.m_debuggerListener);
    }

    private void setBookmarkDescription(int row, String description) {
        Triple<IDebugger, BookmarkManager, Integer> bookmarkTriple = CBookmarkTableHelpers.findBookmark(this.m_debuggerProvider, row);
        BookmarkManager manager = bookmarkTriple.second();
        int index = bookmarkTriple.third();
        manager.getBookmark(index).setDescription(description);
    }

    public void dispose() {
        this.removeListeners();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_NAMES.length;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getRowCount() {
        return this.countBookmarks();
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.getDebugger(row);
            }
            case 1: {
                return this.getBookmarkAddress(row);
            }
            case 2: {
                return this.getBookmarkDescription(row);
            }
        }
        throw new IllegalArgumentException("IE01326: Unknown column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        Preconditions.checkArgument(col == 2, "IE01327: Only the description column can be modified");
        this.setBookmarkDescription(row, value.toString());
    }

    private class InternalDebuggerListener
    implements DebuggerProviderListener {
        private InternalDebuggerListener() {
        }

        @Override
        public void debuggerAdded(BackEndDebuggerProvider provider, IDebugger debugger) {
            debugger.getBookmarkManager().addListener(CBookmarkTableModel.this.m_listener);
        }

        @Override
        public void debuggerRemoved(BackEndDebuggerProvider provider, IDebugger debugger) {
            debugger.getBookmarkManager().removeListener(CBookmarkTableModel.this.m_listener);
        }
    }

    private class InternalBookmarkListener
    implements IBookmarkManagerListener {
        private InternalBookmarkListener() {
        }

        @Override
        public void addedBookmark(BookmarkManager manager, CBookmark bookmark) {
            CBookmarkTableModel.this.fireTableDataChanged();
        }

        @Override
        public void removedBookmark(BookmarkManager manager, CBookmark bookmark) {
            CBookmarkTableModel.this.fireTableDataChanged();
        }
    }
}

