/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Debug.Bookmarks;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.debug.debugger.BackEndDebuggerProvider;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebugger;
import com.google.security.zynamics.binnavi.models.Bookmarks.memory.BookmarkManager;
import com.google.security.zynamics.zylib.general.Triple;

public final class CBookmarkTableHelpers {
    private CBookmarkTableHelpers() {
    }

    public static Triple<IDebugger, BookmarkManager, Integer> findBookmark(BackEndDebuggerProvider debuggerProvider, int row) {
        Preconditions.checkNotNull(debuggerProvider, "IE01322: Debugger provider argument can't be null");
        Preconditions.checkArgument(row >= 0, "IE01323: Row arguments can not be negative");
        int bookmarks = 0;
        for (IDebugger debugger : debuggerProvider.getDebuggers()) {
            if (row >= bookmarks && row < bookmarks + debugger.getBookmarkManager().getNumberOfBookmarks()) {
                return Triple.make(debugger, debugger.getBookmarkManager(), row - bookmarks);
            }
            bookmarks += debugger.getBookmarkManager().getNumberOfBookmarks();
        }
        throw new IllegalArgumentException("IE01324: Invalid row number");
    }
}

