/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Database.implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseConfiguration;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntConnectException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDriverException;
import com.google.security.zynamics.binnavi.Gui.Database.implementations.CDatabaseConnector;
import com.google.security.zynamics.binnavi.Gui.Progress.CGlobalProgressManager;
import com.google.security.zynamics.binnavi.Gui.Progress.IProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.ProgressDialogs.CProgressPanel;
import java.awt.Window;
import java.sql.SQLException;

public final class CDatabaseCreator {
    private CDatabaseCreator() {
    }

    private static void createDatabaseInternal(Window parent, CDatabaseConfiguration configuration) {
        String databaseName = configuration.getName();
        try {
            CDatabaseConnector.initialize(configuration);
            CMessageBox.showInformation(parent, String.format("The database '%s' was created successfully.", databaseName));
        }
        catch (CouldntLoadDriverException exception) {
            String message2 = "E00047: Database driver could not be loaded";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create a database connection because the database driver '%s' could not be loaded", configuration.getDriver()), new String[]{"The database driver string is wrong.", "The database driver file could not be found."}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
            NaviErrorDialog.show(parent, "E00047: Database driver could not be loaded", description, exception);
        }
        catch (CouldntConnectException exception) {
            if (exception.getSqlState().equalsIgnoreCase("28P01")) {
                CMessageBox.showInformation(parent, String.format("The password for user '%s' on database '%s' is invalid", configuration.getUser(), configuration.getUrl()));
                return;
            }
            String message3 = "E00048: Database connection could not be established";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not connect to the database '%s'", configuration.getUrl()), new String[]{exception.getMessage()}, new String[]{"BinNavi can not load data from the given database until the problem is resolved."});
            NaviErrorDialog.show(parent, "E00048: Database connection could not be established", description, exception);
        }
        catch (SQLException exception) {
            String message4 = "E00049: Database could not be created";
            String description = CUtilityFunctions.createDescription(String.format("BinNavi could not create the database '%s'", databaseName), new String[]{exception.getMessage()}, new String[]{"There was a problem with the database connection.", "The database was not created. Please try creating the database again or create it manually if necessary."});
            NaviErrorDialog.show(parent, "E00049: Database could not be created", description, exception);
        }
    }

    public static void createDatabase(final Window parent, final CDatabaseConfiguration configuration) {
        new Thread(){

            @Override
            public void run() {
                final CProgressPanel panel = new CProgressPanel(String.format("Creating database '%s'", configuration.getUrl()), true, false, false);
                IProgressOperation operation = new IProgressOperation(){

                    @Override
                    public String getDescription() {
                        return "Creating database";
                    }

                    @Override
                    public CProgressPanel getProgressPanel() {
                        return panel;
                    }
                };
                CGlobalProgressManager.instance().add(operation);
                panel.start();
                CDatabaseCreator.createDatabaseInternal(parent, configuration);
                CGlobalProgressManager.instance().remove(operation);
            }
        }.start();
    }
}

